/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Attachment;
import org.tinystruct.data.Attachments;
import org.tinystruct.net.URLHandler;
import org.tinystruct.net.URLRequest;
import org.tinystruct.net.URLResponse;
import org.tinystruct.net.handlers.HTTPResponse;
import org.tinystruct.transfer.http.upload.ContentDisposition;

public class HTTPHandler
implements URLHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public URLResponse handleRequest(URLRequest request) throws ApplicationException {
        try {
            URL effectiveUrl;
            ContentDisposition[] boundary = null;
            String contentType = request.getHeaders().get("Content-Type");
            if (contentType != null && contentType.equalsIgnoreCase("multipart/form-data")) {
                boundary = UUID.randomUUID().toString();
                effectiveUrl = request.getURL();
            } else if (request.getParameters() != null && !request.getParameters().isEmpty()) {
                String parameters = this.buildQuery(request.getParameters());
                String urlStr = request.getURL().toString();
                effectiveUrl = URI.create(urlStr.contains("?") ? urlStr + "&" + parameters : urlStr + "?" + parameters).toURL();
            } else {
                effectiveUrl = request.getURL();
            }
            Proxy proxy = request.getProxy();
            if (proxy == null) {
                if (System.getProperty("https.proxyHost") != null && System.getProperty("https.proxyPort") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("https.proxyHost"), Integer.parseInt(System.getProperty("https.proxyPort"))));
                } else if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort"))));
                }
            }
            HttpURLConnection connection = proxy != null ? (HttpURLConnection)effectiveUrl.openConnection(proxy) : (HttpURLConnection)effectiveUrl.openConnection();
            connection.setRequestMethod(request.getMethod());
            if (request.getHeaders() != null) {
                for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (request.getBody() != null || boundary != null || request.getFormData() != null && request.getFormData().length > 0 || request.getAttachments() != null) {
                connection.setDoOutput(true);
                if (boundary != null) {
                    connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + (String)boundary);
                }
                try (OutputStream writer = connection.getOutputStream();){
                    if (boundary != null) {
                        ContentDisposition cd;
                        ContentDisposition[] finalBoundary;
                        if (request.getParameters() != null && !request.getParameters().isEmpty()) {
                            finalBoundary = boundary;
                            for (Map.Entry entry : request.getParameters().entrySet()) {
                                cd = new ContentDisposition((String)entry.getKey(), null, "text/plain", entry.getValue().toString().getBytes(StandardCharsets.UTF_8));
                                writer.write(("--" + (String)finalBoundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd.getTransferBytes());
                            }
                            writer.flush();
                        }
                        if (request.getFormData() != null && request.getFormData().length > 0) {
                            void var10_16;
                            finalBoundary = request.getFormData();
                            int n = finalBoundary.length;
                            boolean bl = false;
                            while (var10_16 < n) {
                                ContentDisposition cd2 = finalBoundary[var10_16];
                                writer.write(("--" + (String)boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd2.getTransferBytes());
                                writer.flush();
                                ++var10_16;
                            }
                        } else if (request.getAttachments() != null) {
                            Attachments attachments = request.getAttachments();
                            for (Attachment attachment : attachments.list()) {
                                cd = new ContentDisposition(attachments.getParameterName(), attachment.getFilename(), "binary", attachment.get());
                                writer.write(("--" + (String)boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd.getTransferBytes());
                                writer.flush();
                            }
                        }
                        writer.write(("--" + (String)boundary + "--\r\n").getBytes(StandardCharsets.UTF_8));
                    }
                    if (request.getBody() != null) {
                        writer.write(request.getBody().getBytes(StandardCharsets.UTF_8));
                    }
                    writer.flush();
                }
            }
            connection.connect();
            if (contentType != null && contentType.contains("text/event-stream")) {
                return new HTTPResponse(connection, System.out::println);
            }
            return new HTTPResponse(connection);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URLResponse handleRequest(URLRequest request, Consumer<String> consumer) throws ApplicationException {
        try {
            URL effectiveUrl;
            ContentDisposition[] boundary = null;
            String contentType = request.getHeaders().get("Content-Type");
            if (contentType != null && contentType.equalsIgnoreCase("multipart/form-data")) {
                boundary = UUID.randomUUID().toString();
                effectiveUrl = request.getURL();
            } else if (request.getParameters() != null && !request.getParameters().isEmpty()) {
                String parameters = this.buildQuery(request.getParameters());
                String urlStr = request.getURL().toString();
                effectiveUrl = URI.create(urlStr.contains("?") ? urlStr + "&" + parameters : urlStr + "?" + parameters).toURL();
            } else {
                effectiveUrl = request.getURL();
            }
            Proxy proxy = request.getProxy();
            if (proxy == null) {
                if (System.getProperty("https.proxyHost") != null && System.getProperty("https.proxyPort") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("https.proxyHost"), Integer.parseInt(System.getProperty("https.proxyPort"))));
                } else if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort"))));
                }
            }
            HttpURLConnection connection = proxy != null ? (HttpURLConnection)effectiveUrl.openConnection(proxy) : (HttpURLConnection)effectiveUrl.openConnection();
            connection.setRequestMethod(request.getMethod());
            if (request.getHeaders() != null) {
                for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (request.getBody() != null || boundary != null || request.getFormData() != null && request.getFormData().length > 0 || request.getAttachments() != null) {
                connection.setDoOutput(true);
                if (boundary != null) {
                    connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + (String)boundary);
                }
                try (OutputStream writer = connection.getOutputStream();){
                    if (boundary != null) {
                        ContentDisposition cd;
                        ContentDisposition[] finalBoundary;
                        if (request.getParameters() != null && !request.getParameters().isEmpty()) {
                            finalBoundary = boundary;
                            for (Map.Entry entry : request.getParameters().entrySet()) {
                                cd = new ContentDisposition((String)entry.getKey(), null, "text/plain", entry.getValue().toString().getBytes(StandardCharsets.UTF_8));
                                writer.write(("--" + (String)finalBoundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd.getTransferBytes());
                            }
                            writer.flush();
                        }
                        if (request.getFormData() != null && request.getFormData().length > 0) {
                            void var11_17;
                            finalBoundary = request.getFormData();
                            int n = finalBoundary.length;
                            boolean bl = false;
                            while (var11_17 < n) {
                                ContentDisposition cd2 = finalBoundary[var11_17];
                                writer.write(("--" + (String)boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd2.getTransferBytes());
                                writer.flush();
                                ++var11_17;
                            }
                        } else if (request.getAttachments() != null) {
                            Attachments attachments = request.getAttachments();
                            for (Attachment attachment : attachments.list()) {
                                cd = new ContentDisposition(attachments.getParameterName(), attachment.getFilename(), "binary", attachment.get());
                                writer.write(("--" + (String)boundary + "\r\n").getBytes(StandardCharsets.UTF_8));
                                writer.write(cd.getTransferBytes());
                                writer.flush();
                            }
                        }
                        writer.write(("--" + (String)boundary + "--\r\n").getBytes(StandardCharsets.UTF_8));
                    }
                    if (request.getBody() != null) {
                        writer.write(request.getBody().getBytes(StandardCharsets.UTF_8));
                    }
                    writer.flush();
                }
            }
            connection.connect();
            String transferEncoding = connection.getHeaderField("Transfer-Encoding");
            if ("chunked".equalsIgnoreCase(transferEncoding)) {
                return new HTTPResponse(connection, consumer);
            }
            return new HTTPResponse(connection);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    @Override
    public CompletableFuture<URLResponse> handleRequestAsync(URLRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.handleRequest(request);
            }
            catch (ApplicationException e) {
                throw new CompletionException(e);
            }
        });
    }

    private String buildQuery(Map<String, Object> parameters) {
        StringBuilder queryBuilder = new StringBuilder();
        parameters.forEach((key, value) -> {
            if (queryBuilder.length() > 0) {
                queryBuilder.append("&");
            }
            queryBuilder.append((String)key).append("=").append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        });
        return queryBuilder.toString();
    }
}

