/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.brotli.dec.BrotliInputStream;
import org.tinystruct.net.URLResponse;

class HTTPResponse
implements URLResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;

    public HTTPResponse(HttpURLConnection connection) throws IOException {
        InputStream in;
        this.statusCode = connection.getResponseCode();
        this.headers = connection.getHeaderFields();
        InputStream inputStream = in = this.statusCode >= 200 && this.statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        if (in != null) {
            String contentEncoding = connection.getContentEncoding();
            InputStream decodedStream = HTTPResponse.getDecodedInputStream(contentEncoding, in);
            this.body = new String(decodedStream.readAllBytes(), StandardCharsets.UTF_8);
            decodedStream.close();
        } else {
            this.body = "";
        }
    }

    public HTTPResponse(HttpURLConnection connection, Consumer<String> onMessage) throws IOException {
        this.statusCode = connection.getResponseCode();
        this.headers = connection.getHeaderFields();
        this.body = "";
        this.handleSSE(connection, onMessage);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    private static InputStream getDecodedInputStream(String contentEncoding, InputStream in) throws IOException {
        if (contentEncoding != null) {
            switch (contentEncoding.toLowerCase()) {
                case "gzip": {
                    return new GZIPInputStream(in);
                }
                case "deflate": {
                    return new DeflaterInputStream(in);
                }
                case "br": {
                    return new BrotliInputStream(in);
                }
            }
        }
        return in;
    }

    private void handleSSE(HttpURLConnection connection, Consumer<String> listener) throws IOException {
        String transferEncoding = connection.getHeaderField("Transfer-Encoding");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                listener.accept(line + "\n");
            }
        }
        if (transferEncoding == null || transferEncoding.equalsIgnoreCase("identity")) {
            connection.disconnect();
        }
    }
}

