/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.tinystruct.Application;
import org.tinystruct.application.Action;
import org.tinystruct.application.ActionRegistry;
import org.tinystruct.system.annotation.Action;
import org.tinystruct.system.annotation.Argument;
import org.tinystruct.system.cli.CommandArgument;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.cli.CommandOption;

public class AnnotationProcessor {
    private final Application app;
    private final ActionRegistry actionRegistry = ActionRegistry.getInstance();

    public AnnotationProcessor(Application app) {
        this.app = app;
    }

    public void processActionAnnotations() {
        Action annotation = this.app.getClass().getAnnotation(Action.class);
        if (annotation != null) {
            Argument[] optionAnnotations = annotation.options();
            ArrayList<CommandOption> options = new ArrayList<CommandOption>();
            CommandLine commandLine = new CommandLine(this.app, annotation.value(), annotation.description());
            this.app.getCommandLines().put(annotation.value(), commandLine);
            for (Argument optionAnnotation : optionAnnotations) {
                String key = optionAnnotation.key();
                String optionDescription = optionAnnotation.description();
                CommandOption option = new CommandOption(key, null, optionDescription);
                options.add(option);
            }
            this.app.getCommandLines().get(annotation.value()).setOptions(options);
        }
        for (Method method : this.app.getClass().getDeclaredMethods()) {
            Action actionAnnotation = method.getAnnotation(Action.class);
            if (actionAnnotation == null) continue;
            String commandName = actionAnnotation.value();
            String description = actionAnnotation.description();
            String example = actionAnnotation.example();
            String path = actionAnnotation.value();
            Action.Mode mode = actionAnnotation.mode();
            CommandLine commandLine = new CommandLine(this.app, commandName, description);
            this.app.getCommandLines().put(commandName, commandLine);
            Set<CommandArgument<String, Object>> arguments = AnnotationProcessor.getCommandArguments(actionAnnotation);
            this.app.getCommandLines().get(commandName).setArguments(arguments);
            Argument[] optionAnnotations = actionAnnotation.options();
            ArrayList<CommandOption> options = new ArrayList<CommandOption>();
            for (Argument optionAnnotation : optionAnnotations) {
                String key = optionAnnotation.key();
                String optionDescription = optionAnnotation.description();
                CommandOption option = new CommandOption(key, null, optionDescription);
                options.add(option);
            }
            this.app.getCommandLines().get(commandName).setOptions(options);
            if (!example.isEmpty()) {
                this.app.getCommandLines().get(commandName).setExample(example);
            }
            if (mode != Action.Mode.All) {
                this.actionRegistry.set(this.app, path, method.getName(), mode);
                continue;
            }
            this.actionRegistry.set(this.app, path, method.getName());
        }
    }

    private static Set<CommandArgument<String, Object>> getCommandArguments(Action actionAnnotation) {
        Argument[] argumentAnnotations = actionAnnotation.arguments();
        HashSet<CommandArgument<String, Object>> arguments = new HashSet<CommandArgument<String, Object>>();
        for (Argument argumentAnnotation : argumentAnnotations) {
            String key = argumentAnnotation.key();
            String argDescription = argumentAnnotation.description();
            CommandArgument<String, Object> argument = new CommandArgument<String, Object>(key, null, argDescription);
            arguments.add(argument);
        }
        return arguments;
    }
}

