/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.application.ActionRegistry;
import org.tinystruct.application.Context;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Platform;
import org.tinystruct.system.Settings;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.util.TextFileLoader;

public final class ApplicationManager {
    public static final String VERSION = "1.6.0";
    private static final ConcurrentHashMap<String, Application> applications = new ConcurrentHashMap();
    private static final ActionRegistry ROUTE_REGISTRY_INSTANCE = ActionRegistry.getInstance();
    private static Configuration<String> settings;
    private static volatile boolean initialized;

    private ApplicationManager() {
    }

    public static void init(Configuration<String> config) throws ApplicationException {
        settings = config;
        ApplicationManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws ApplicationException {
        if (initialized) {
            return;
        }
        Class<ApplicationManager> clazz = ApplicationManager.class;
        synchronized (ApplicationManager.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            settings = settings == null ? new Settings("application.properties") : settings;
            ApplicationManager.generateDispatcherCommand(VERSION, false);
            if (!settings.get("default.import.applications").trim().isEmpty()) {
                StringTokenizer tokenizer = new StringTokenizer(settings.get("default.import.applications"), ";");
                while (tokenizer.hasMoreTokens()) {
                    String appClassName = tokenizer.nextToken().trim();
                    if (appClassName.isEmpty()) continue;
                    try {
                        Application app = (Application)Class.forName(appClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        ApplicationManager.install(app);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new ApplicationException(e.toString(), e);
                    }
                }
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void generateDispatcherCommand(String version, boolean force) throws ApplicationException {
        block22: {
            String scriptName = Platform.isWindows() ? "dispatcher.cmd" : "dispatcher";
            String userDir = System.getProperty("user.dir");
            if (userDir.endsWith(File.separator + "bin")) {
                userDir = userDir.substring(0, userDir.length() - 4);
            }
            Object paths = userDir + File.separator + "bin" + File.separator + scriptName;
            String origin = paths;
            Path path = Paths.get((String)paths, new String[0]);
            if (force || !Files.exists(Paths.get(scriptName, new String[0]), new LinkOption[0]) && !Files.exists(path, new LinkOption[0])) {
                try {
                    while (!Files.exists(path, new LinkOption[0])) {
                        paths = ((String)paths).substring(0, ((String)paths).lastIndexOf(File.separator));
                        path = Paths.get((String)paths, new String[0]);
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    path = Paths.get(origin, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        Files.createFile(path, new FileAttribute[0]);
                    }
                    String cmd = null;
                    try (InputStream in = ApplicationManager.class.getResourceAsStream("/" + scriptName);){
                        if (null != in) {
                            TextFileLoader loader = new TextFileLoader(in);
                            cmd = loader.getContent().toString();
                            cmd = cmd.replaceAll("\\{%VERSION%}", version);
                        }
                    }
                    catch (IOException e) {
                        throw new ApplicationRuntimeException(e.getMessage(), e);
                    }
                    if (cmd == null) break block22;
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(cmd);
                    }
                }
                catch (IOException e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
            }
        }
    }

    public static void install(Application app) {
        if (settings == null) {
            throw new ApplicationRuntimeException("Application configuration has not been initialized or specified.");
        }
        if (!applications.containsKey(app.getName())) {
            app.setConfiguration(settings);
            applications.putIfAbsent(app.getName(), app);
        }
    }

    public static void install(Application app, Configuration<String> config) {
        settings = config;
        try {
            ApplicationManager.init();
        }
        catch (ApplicationException e) {
            throw new ApplicationRuntimeException(e.getMessage(), e.getRootCause());
        }
        ApplicationManager.install(app);
    }

    public static boolean uninstall(Application application) {
        Object[] list;
        applications.remove(application.getName());
        ActionRegistry actionRegistry = ROUTE_REGISTRY_INSTANCE;
        for (Object item : list = actionRegistry.list().toArray()) {
            Action action = (Action)item;
            if (!action.getApplicationName().equalsIgnoreCase(application.getName())) continue;
            return actionRegistry.remove(action);
        }
        return false;
    }

    public static Application get(String clsid) {
        return applications.get(clsid);
    }

    public static Collection<Application> list() {
        return applications.values();
    }

    public static Object call(String path, Context context) throws ApplicationException {
        return ApplicationManager.call(path, context, Action.Mode.All);
    }

    public static Object call(String path, Context context, Action.Mode mode) throws ApplicationException {
        CommandLine command;
        String method;
        if (path == null || path.trim().isEmpty()) {
            throw new ApplicationException("Invalid: empty path", 400);
        }
        String string = method = context != null && context.getAttribute("METHOD") != null ? context.getAttribute("METHOD").toString() : null;
        if (context != null && context.getAttribute("--help") != null && (command = ROUTE_REGISTRY_INSTANCE.getCommand(path)) != null) {
            return command;
        }
        Action action = ROUTE_REGISTRY_INSTANCE.getAction(path, method);
        if (action == null) {
            throw new ApplicationException("No matching function found for path [" + path + "]. Ensure the path is correct and the function is public.", 404);
        }
        if (action.getMode().ordinal() < mode.ordinal()) {
            throw new ApplicationException("The action is not allowed to be executed.");
        }
        if (context != null) {
            context.setAttribute("REQUEST_PATH", path);
            action.setContext(context);
        }
        return action.execute();
    }

    public static Configuration<String> getConfiguration() {
        return settings;
    }

    static {
        initialized = false;
    }
}

