/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;

public final class ClassFileLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(ClassFileLoader.class.getName());
    private final Configuration<String> config = new Settings("application.properties");

    private ClassFileLoader() {
    }

    public static ClassFileLoader getInstance() {
        return SingletonHolder.loader;
    }

    @Override
    public Class<?> findClass(String name) {
        String appsPackage = this.config.get("default.apps.package");
        String appsPackageDir = this.config.get("default.apps.path") + "/" + appsPackage.replaceAll("\\.", "/");
        StringBuilder path = new StringBuilder();
        if (this.config.get("default.apps.path").startsWith("/")) {
            path.append(appsPackageDir);
        } else {
            path.append(this.config.get("system.directory")).append("/").append(appsPackageDir);
        }
        path.append("/").append(name);
        if (!name.endsWith(".class")) {
            path.append(".class");
        } else {
            name = name.replace(".class", "");
        }
        try {
            byte[] data = this.getBytes(path.toString());
            return this.defineClass(appsPackage + "." + name, data, 0, data.length);
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public Class<?> findClass(String path, String simpleClassName) {
        this.config.set("default.apps.path", path);
        return this.findClass(simpleClassName);
    }

    private byte[] getBytes(String filename) throws ApplicationException {
        byte[] byArray;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        try {
            long len = new File(filename).length();
            byte[] raw = new byte[(int)len];
            int bytesRead = in.read(raw);
            if ((long)bytesRead != len) {
                throw new ApplicationException("Cannot load the class file bytes completely, " + bytesRead + " != " + len);
            }
            byArray = raw;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        in.close();
        return byArray;
    }

    private static class SingletonHolder {
        static final ClassFileLoader loader = new ClassFileLoader();

        private SingletonHolder() {
        }
    }
}

