/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.tinystruct.AbstractApplication;
import org.tinystruct.Application;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.application.Context;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.repository.Type;
import org.tinystruct.data.tools.Generator;
import org.tinystruct.data.tools.H2Generator;
import org.tinystruct.data.tools.MSSQLGenerator;
import org.tinystruct.data.tools.MySQLGenerator;
import org.tinystruct.data.tools.SQLiteGenerator;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.EventDispatcher;
import org.tinystruct.system.Platform;
import org.tinystruct.system.RemoteDispatcher;
import org.tinystruct.system.Settings;
import org.tinystruct.system.annotation.Action;
import org.tinystruct.system.annotation.Argument;
import org.tinystruct.system.cli.Kernel32;
import org.tinystruct.system.event.UpgradeEvent;
import org.tinystruct.system.util.StringUtilities;
import org.tinystruct.system.util.URLResourceLoader;
import org.tinystruct.transfer.http.ReadableByteChannelWrapper;

@Action(value="", description="A command line tool for tinystruct framework", options={@Argument(key="import", description="Import application"), @Argument(key="allow-remote-access", description="Allow to be accessed remotely"), @Argument(key="host", description="Host name / IP"), @Argument(key="logo", description="Print logo"), @Argument(key="settings", description="Print settings"), @Argument(key="version", description="Print version"), @Argument(key="help", description="Print help information")}, mode=Action.Mode.CLI)
public class Dispatcher
extends AbstractApplication
implements RemoteDispatcher {
    public static final String OK = "OK!";
    private static final Logger logger = Logger.getLogger(Dispatcher.class.getName());
    private boolean virtualTerminal;
    private final EventDispatcher eventDispatcher = EventDispatcher.getInstance();

    public static void main(String[] args) throws RemoteException {
        Settings config = new Settings();
        if (config.get("system.directory") == null || "".equals(config.get("system.directory"))) {
            config.set("system.directory", System.getProperty("user.dir"));
        }
        ApplicationContext context = new ApplicationContext();
        final Dispatcher dispatcher = new Dispatcher();
        ApplicationManager.install(dispatcher, config);
        if (args.length > 0) {
            ArrayList<String> commands = new ArrayList<String>();
            int start = 0;
            if (!args[0].startsWith("--") && !args[0].startsWith("-")) {
                commands.add(args[0]);
                start = 1;
            }
            for (int i = start; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    if (i + 1 < args.length) {
                        String value;
                        if (!(value = args[++i].trim()).isEmpty() && !value.startsWith("--")) {
                            if (context.getAttribute(arg) != null) {
                                ArrayList<String> list;
                                Object attribute = context.getAttribute(arg);
                                if (attribute instanceof List) {
                                    list = (ArrayList<String>)attribute;
                                } else {
                                    list = new ArrayList<String>();
                                    list.add(Objects.requireNonNull(context.getAttribute(arg)).toString());
                                }
                                list.add(value);
                                context.setAttribute(arg, list);
                                continue;
                            }
                            context.setAttribute(arg, value);
                            continue;
                        }
                        --i;
                        context.setAttribute(arg, true);
                        continue;
                    }
                    context.setAttribute(arg, true);
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String[] args0 = arg.substring(2).split("=");
                    System.setProperty(args0[0], args0[1]);
                    continue;
                }
                commands.add(arg);
            }
            boolean remote = false;
            RemoteDispatcher remoteDispatcher = null;
            if (context.getAttribute("--host") != null) {
                try {
                    Registry registry = LocateRegistry.getRegistry(Objects.requireNonNull(context.getAttribute("--host")).toString());
                    remoteDispatcher = (RemoteDispatcher)registry.lookup("Dispatcher");
                    if (remoteDispatcher != null) {
                        remote = true;
                    }
                }
                catch (RemoteException e) {
                    System.err.println(e.getCause().getMessage());
                    System.exit(0);
                }
                catch (NotBoundException e) {
                    System.err.println(e.getCause().getMessage());
                    System.exit(0);
                }
            }
            boolean disableHelper = false;
            if (context.getAttribute("--allow-remote-access") != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        dispatcher.bind(dispatcher);
                    }
                }).start();
                disableHelper = true;
            }
            if (context.getAttribute("--import") != null && !Boolean.parseBoolean(Objects.requireNonNull(context.getAttribute("--import")).toString())) {
                List<String> list = context.getAttribute("--import") instanceof List ? (List<String>)context.getAttribute("--import") : List.of(Objects.requireNonNull(context.getAttribute("--import")).toString());
                if (remote) {
                    remoteDispatcher.install(config, list);
                } else {
                    dispatcher.install(config, list);
                }
            } else {
                dispatcher.install(config, null);
            }
            if (remote) {
                if (!commands.isEmpty()) {
                    for (String command : commands) {
                        System.out.print(remoteDispatcher.execute(command, context));
                    }
                } else {
                    System.out.print(remoteDispatcher.execute(null, context));
                }
                System.exit(0);
            }
            if (!commands.isEmpty()) {
                for (String command : commands) {
                    if (disableHelper && command == null) continue;
                    dispatcher.execute(command, context);
                }
            } else if (!disableHelper) {
                dispatcher.execute(null, context);
            }
        } else {
            System.out.println(dispatcher.help());
        }
    }

    @Override
    public Object execute(String command, Context context) throws RemoteException {
        Object output = OK;
        try {
            if (command != null) {
                Object o = ApplicationManager.call(command, context, Action.Mode.CLI);
                if (o != null) {
                    System.out.println(o);
                    return o;
                }
            } else {
                Dispatcher dispatcher = (Dispatcher)ApplicationManager.get(Dispatcher.class.getName());
                output = context.getAttribute("--version") != null ? dispatcher.version() : (context.getAttribute("--logo") != null ? dispatcher.logo() : (context.getAttribute("--settings") != null ? ApplicationManager.call("--settings", context, Action.Mode.CLI) : dispatcher.help()));
                System.out.println(output);
            }
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            logger.info("* SOLUTION: if it's caused by a ClassNotFoundException, ensuring that all dependencies are properly downloaded and available in the classpath is crucial. The command uses Maven Wrapper (mvnw) to copy all dependencies to a specified directory (lib) will be helpful to resolve the issue: \n.\\mvnw dependency:copy-dependencies -DoutputDirectory=lib\n");
        }
        return output;
    }

    @Action(value="install", description="Install a package", options={@Argument(key="app", description="Packages to be installed")}, mode=Action.Mode.CLI)
    public void install() {
        String appName = (String)this.getContext().getAttribute("--app");
        if (appName == null) {
            throw new ApplicationRuntimeException("The app could not be found in the context.");
        }
        System.out.println("Installing...");
        try {
            this.install(this.getConfiguration(), List.of(appName));
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        System.out.println("Completed installation for " + appName + "!");
    }

    @Override
    public void install(Configuration<String> config, List<String> list) throws RemoteException {
        if (list != null && !list.isEmpty()) {
            list.forEach(appName -> {
                try {
                    Application app = (Application)Class.forName(appName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ApplicationManager.install(app, config);
                }
                catch (InstantiationException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                catch (NoSuchMethodException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    logger.info("* SOLUTION: if it's caused by a ClassNotFoundException, ensuring that all dependencies are properly downloaded and available in the classpath is crucial. The command uses Maven Wrapper (mvnw) to copy all dependencies to a specified directory (lib) will be helpful to resolve the issue: \n.\\mvnw dependency:copy-dependencies -DoutputDirectory=lib\n");
                }
            });
        }
    }

    @Action(value="update", options={@Argument(key="force", description="Force to update the framework")}, description="Update for latest version", mode=Action.Mode.CLI)
    public String update() {
        System.out.print("Checking...");
        System.out.println("\rThe current project is based on tinystruct-" + this.color("1.6.0", 32));
        try {
            URLResourceLoader loader = new URLResourceLoader(new URL("https://repo1.maven.org/maven2/org/tinystruct/tinystruct/maven-metadata.xml"));
            StringBuilder content = loader.getContent();
            String latestVersion = content.substring(content.indexOf("<latest>") + 8, content.indexOf("</latest>"));
            if (this.getContext().getAttribute("--force") == null && latestVersion.equalsIgnoreCase("1.6.0")) {
                return "\r" + this.color("You are already using the latest available Dispatcher version 1.6.0.", 32);
            }
            this.eventDispatcher.dispatch(new UpgradeEvent(latestVersion));
            ApplicationManager.generateDispatcherCommand(latestVersion, true);
        }
        catch (MalformedURLException | ApplicationException e) {
            return e.getMessage();
        }
        return "\rCompleted! \nRun 'bin/dispatcher --help' for more information.";
    }

    @Action(value="download", description="Download a resource from other servers", options={@Argument(key="url", description="URL resource to be downloaded"), @Argument(key="http.proxyHost", description="Proxy host for http"), @Argument(key="http.proxyPort", description="Proxy port for http"), @Argument(key="https.proxyHost", description="Proxy host for https"), @Argument(key="https.proxyPort", description="Proxy port for https")}, mode=Action.Mode.CLI)
    public void download() throws ApplicationException {
        if (this.getContext().getAttribute("--url") != null) {
            try {
                URL uri = new URL(this.getContext().getAttribute("--url").toString());
                this.download(uri, uri.getFile());
            }
            catch (MalformedURLException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
        }
    }

    public void download(URL uri, String destination) throws ApplicationException {
        try (ReadableByteChannelWrapper rbc = new ReadableByteChannelWrapper(uri);){
            if (destination.trim().length() <= 1) {
                destination = uri.toString().replaceAll("http://|https://|/", "+");
            }
            destination = destination.replaceAll("\\.\\.", "");
            if ((destination = destination.replaceAll("/", "\\" + File.separator)).contains("?")) {
                destination = destination.substring(0, destination.indexOf("?"));
            }
            String path = new File("").getAbsolutePath() + File.separatorChar + destination;
            Path dest = Paths.get(path, new String[0]);
            try {
                Path parent = dest.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (!Files.exists(dest, new LinkOption[0])) {
                    Files.createFile(dest, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
            try (FileOutputStream fos = new FileOutputStream(path);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
        }
        catch (Exception e) {
            throw new ApplicationException("Could not be downloaded:" + e.getMessage(), e.getCause());
        }
    }

    @Action(value="exec", description="To execute native command(s)", options={@Argument(key="shell-command", description="Commands needs to be executed"), @Argument(key="output", description="Specify a boolean value to determine output of the command")}, mode=Action.Mode.CLI)
    public void exec() throws ApplicationException {
        if (this.getContext().getAttribute("--shell-command") == null) {
            throw new ApplicationException("Invalid shell command");
        }
        boolean output = true;
        if (this.getContext().getAttribute("--output") != null) {
            output = Boolean.parseBoolean(this.getContext().getAttribute("--output").toString());
        }
        String cmd = this.getContext().getAttribute("--shell-command").toString();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            if (output) {
                String line;
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));
                while ((line = input.readLine()) != null) {
                    System.out.println(line);
                }
                input.close();
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream(), Charset.defaultCharset()));
                while ((line = error.readLine()) != null) {
                    System.out.println(line);
                }
                error.close();
            }
            p.onExit().get().destroy();
        }
        catch (Exception err) {
            throw new ApplicationException(err.getMessage(), err);
        }
    }

    @Action(value="sql-execute", description="Executes the given SQL statement", options={@Argument(key="sql", description="an SQL Data Manipulation Language (DML) statement, such as INSERT, UPDATE or DELETE; or an SQL statement that returns nothing, such as a DDL statement.")}, mode=Action.Mode.CLI)
    public void executeUpdate() throws ApplicationException {
        if (this.getContext().getAttribute("--sql") == null) {
            throw new ApplicationException("Invalid SQL Statement.");
        }
        String query = this.getContext().getAttribute("--sql").toString();
        try (DatabaseOperator operator = new DatabaseOperator();){
            if (operator.update(query) > 0) {
                System.out.println("Done!");
            }
        }
        catch (ApplicationException e) {
            System.err.println(e.getCause().getMessage());
        }
    }

    @Action(value="sql-query", description="Executes the given SQL statement", options={@Argument(key="sql", description="an SQL statement to be sent to the database, typically a static SQL SELECT statement")}, mode=Action.Mode.CLI)
    public void executeQuery() throws ApplicationException {
        if (this.getContext().getAttribute("--sql") == null) {
            throw new ApplicationException("Invalid SQL Statement.");
        }
        String sql = this.getContext().getAttribute("--sql").toString();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.disableSafeCheck();
            ResultSet set = operator.query(sql);
            int columnCount = set.getMetaData().getColumnCount();
            String[] columns = new String[columnCount];
            int[] maxItems = new int[columnCount];
            if (columnCount > 0) {
                for (int i = 0; i < columnCount; ++i) {
                    columns[i] = set.getMetaData().getColumnName(i + 1);
                    maxItems[i] = columns[i].length();
                }
            }
            ArrayList<String[]> list = new ArrayList<String[]>();
            list.add(columns);
            while (set.next()) {
                String[] data = new String[columnCount];
                for (int i = 0; i < columns.length; ++i) {
                    String fieldValue;
                    Object field = set.getObject(i + 1);
                    data[i] = fieldValue = field == null ? "" : field.toString();
                    if (fieldValue.length() <= maxItems[i]) continue;
                    maxItems[i] = fieldValue.length();
                }
                list.add(data);
            }
            list.forEach(item -> {
                for (int i = 0; i < columns.length; ++i) {
                    System.out.print("|" + StringUtilities.rightPadding(item[i], maxItems[i], ' '));
                }
                System.out.println("|");
            });
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void init() {
        this.setTemplateRequired(false);
        this.eventDispatcher.registerHandler(UpgradeEvent.class, evt -> {
            System.out.print("\rGot a new version " + evt.getLatestVersion() + "...");
            System.out.print("\rDownloading...");
            try {
                this.download(URI.create("https://repo1.maven.org/maven2/org/tinystruct/tinystruct/" + evt.getLatestVersion() + "/tinystruct-" + evt.getLatestVersion() + "-jar-with-dependencies.jar").toURL(), "lib/tinystruct-" + evt.getLatestVersion() + "-jar-with-dependencies.jar");
                System.out.println("\nDownloaded (" + this.color(evt.getLatestVersion(), 32) + ").");
                System.out.print("\rUpdating..");
                boolean git = new File(".git").exists();
                if (git) {
                    this.getContext().setAttribute("--shell-command", "git pull");
                    this.exec();
                    System.out.println("Reminder: DO NOT forget to compile it.");
                } else {
                    boolean maven;
                    boolean pom = new File("pom.xml").exists();
                    boolean bl = maven = Platform.isWindows() ? new File("mvnw.cmd").exists() : new File("mvnw").exists();
                    if (pom && maven) {
                        this.getContext().setAttribute("--shell-command", "./mvnw versions:use-dep-version -Dincludes=org.tinystruct:tinystruct -DdepVersion=" + evt.getLatestVersion() + " -DforceVersion=true");
                        this.getContext().setAttribute("--output", false);
                        this.exec();
                        this.getContext().setAttribute("--shell-command", "./mvnw compile");
                        this.getContext().setAttribute("--output", true);
                        this.exec();
                    }
                }
            }
            catch (MalformedURLException | ApplicationException e) {
                throw new ApplicationRuntimeException(e.getMessage(), e);
            }
        });
    }

    private void bind(Dispatcher dispatcher) {
        try {
            String name = "Dispatcher";
            RemoteDispatcher stub = (RemoteDispatcher)UnicastRemoteObject.exportObject((Remote)dispatcher, 0);
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.bind(name, stub);
            logger.warning("It will be allowed to send commands to the machine with --host option.");
        }
        catch (Exception e) {
            System.err.println(e.getCause().getMessage());
        }
    }

    @Action(value="say", description="Output words", arguments={@Argument(key="words", description="What you want to say")})
    public String say(String words) {
        return words;
    }

    @Action(value="set", description="Set system property", mode=Action.Mode.CLI)
    public String setProperty(String propertyName) {
        if (this.getContext().getAttribute(propertyName) == null) {
            throw new ApplicationRuntimeException("The key " + propertyName + " could not be found in the context.");
        }
        String property = this.getContext().getAttribute(propertyName).toString();
        propertyName = propertyName.substring(2);
        System.setProperty(propertyName, property);
        return propertyName + ":" + System.getProperty(propertyName);
    }

    @Action(value="--settings", description="Print settings", mode=Action.Mode.CLI)
    public StringBuilder settings() {
        Object[] names = this.getConfiguration().propertyNames().toArray(new String[0]);
        Arrays.sort(names);
        StringBuilder settings = new StringBuilder();
        for (Object name : names) {
            settings.append((String)name).append(":").append(this.getConfiguration().get((String)name)).append("\n");
        }
        return settings;
    }

    @Action(value="open", description="Start a default browser to open the specific URL", options={@Argument(key="url", description="URL resource to be downloaded")}, mode=Action.Mode.CLI)
    public void open() throws ApplicationException {
        if (this.getContext().getAttribute("--url") == null) {
            throw new ApplicationException("Invalid URL.");
        }
        final String url = this.getContext().getAttribute("--url").toString();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(new URI(url));
                    }
                    catch (IOException | URISyntaxException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }).start();
    }

    @Action(value="generate", description="POJO object generator", mode=Action.Mode.CLI)
    public void generate() throws ApplicationException {
        Generator generator;
        Scanner scanner = new Scanner(System.in);
        System.out.println("To follow up the below steps to generate code for your project. CTRL+C to exit.");
        System.out.print("Please provide table name(s) to generate POJO code and use the delimiter `;` for multiple items:");
        String tableNames = scanner.nextLine();
        while (tableNames.isBlank()) {
            System.out.print("Please provide table name(s) to generate POJO code and use the delimiter `;` for multiple items:");
            tableNames = scanner.nextLine();
        }
        System.out.print("Please specify the base path to place the Java code files. [src/main/java/custom/objects]:");
        String basePath = scanner.nextLine();
        System.out.print("Please specify the packages to be imported in code and use delimiter `;` for multiple items. [java.time.LocalDateTime]:");
        String imports = scanner.nextLine();
        scanner.close();
        String driver = this.getConfiguration().get("driver");
        if (driver.trim().isEmpty()) {
            throw new ApplicationRuntimeException("Database Connection Driver has not been set in application.properties!");
        }
        int index = -1;
        int length = Type.values().length;
        for (int i = 0; i < length; ++i) {
            if (!driver.contains(Type.values()[i].name().toLowerCase())) continue;
            index = i;
            break;
        }
        switch (index) {
            case 1: {
                generator = new MSSQLGenerator();
                break;
            }
            case 2: {
                generator = new SQLiteGenerator();
                break;
            }
            case 3: {
                generator = new H2Generator();
                break;
            }
            default: {
                generator = new MySQLGenerator();
            }
        }
        try {
            String[] list;
            basePath = basePath.isBlank() ? "src/main/java/custom/objects" : basePath;
            generator.setPath(basePath);
            String packageName = basePath.replace("src/main/java/", "").replace("/", ".");
            generator.setPackageName(packageName);
            generator.importPackages(imports.isBlank() ? "java.time.LocalDateTime" : imports);
            for (String className : list = tableNames.split(";")) {
                generator.create(className, className);
                System.out.printf("File(s) for %s has been generated. %n", className);
            }
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Action(value="maven-wrapper", description="Extract Maven Wrapper", arguments={@Argument(key="--jar-file-path", description="The jar file path which included maven-wrapper.zip"), @Argument(key="--destination-dir", description="The destination dir ")}, mode=Action.Mode.CLI)
    public void extractMavenWrapperFromJar() throws IOException, ApplicationException {
        block18: {
            if (this.getContext().getAttribute("--jar-file-path") == null) {
                throw new ApplicationException("Missing --jar-file-path. It should point to a jar file of tinystruct framework.");
            }
            String jarFilePath = this.getContext().getAttribute("--jar-file-path").toString();
            String destinationDir = this.getContext().getAttribute("--destination-dir") != null ? this.getContext().getAttribute("--destination-dir").toString() : this.getConfiguration().getOrDefault("system.directory", ".");
            try (JarFile jarFile = new JarFile(jarFilePath);){
                JarEntry entry = jarFile.getJarEntry("maven-wrapper.zip");
                if (entry == null) break block18;
                File destFile = new File(destinationDir, "maven-wrapper.zip");
                try (InputStream inputStream = jarFile.getInputStream(entry);
                     FileOutputStream outputStream = new FileOutputStream(destFile);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    System.out.println("Maven wrapper ZIP extracted successfully.");
                }
            }
        }
    }

    @Action(value="--logo", description="Print logo", mode=Action.Mode.CLI)
    public String logo() {
        return "\n  _/  '         _ _/  _     _ _/   \n  /  /  /) (/ _)  /  /  (/ (  /  " + this.color("1.6.0", 32) + "  \n           /                       \n";
    }

    public String color(Object s, int color) {
        if (!this.virtualTerminal && Platform.isWindows() && Platform.isJnaAvailable()) {
            Kernel32.INSTANCE.SetConsoleMode(Kernel32.INSTANCE.GetStdHandle(-11), 7);
            this.virtualTerminal = true;
        }
        return "\u001b[" + color + "m" + String.valueOf(s) + "\u001b[0m";
    }

    @Override
    @Action(value="--version", description="Print version", mode=Action.Mode.CLI)
    public String version() {
        return String.format("Dispatcher (cli) (built on %sinystruct-%s) %nCopyright (c) 2013-%s James M. ZHOU", this.color("t", 34), "1.6.0", LocalDate.now().getYear());
    }

    @Override
    @Action(value="--help", description="Print help information", mode=Action.Mode.CLI)
    public String help() {
        StringBuilder builder = new StringBuilder("Usage: bin" + File.separator + "dispatcher COMMAND [OPTIONS]\n");
        StringBuilder commands = new StringBuilder("Commands: \n");
        StringBuilder options = new StringBuilder("Options: \n");
        StringBuilder examples = new StringBuilder("Example(s): \n");
        int length = examples.length();
        int optionsLength = options.length();
        HashMap commandLines = new HashMap();
        Collection<Application> apps = ApplicationManager.list();
        apps.forEach(app -> commandLines.putAll(app.getCommandLines()));
        OptionalInt longSizeCommand = commandLines.keySet().stream().mapToInt(String::length).max();
        int max = longSizeCommand.orElse(0);
        Stream sorted = this.commandLines.values().stream().sorted();
        sorted.forEach(commandLine -> {
            String command = commandLine.getCommand();
            String description = commandLine.getDescription();
            String example = commandLine.getExample();
            if (!command.startsWith("--")) {
                if (command.isEmpty()) {
                    builder.append(description).append("\n");
                    commandLine.getOptions().forEach(option -> options.append("\t").append(StringUtilities.rightPadding((String)option.getKey(), max, ' ')).append("\t").append(option.getDescription()).append("\n"));
                } else {
                    commands.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
                }
            }
            if (example != null && !example.isEmpty()) {
                examples.append(example).append("\n");
            }
        });
        builder.append((CharSequence)commands).append("\n");
        if (optionsLength < options.length()) {
            builder.append((CharSequence)options);
        }
        if (length < examples.length()) {
            builder.append((CharSequence)examples);
        }
        builder.append("\nRun 'bin").append(File.separator).append("dispatcher COMMAND --help' for more information on a command.");
        return builder.toString();
    }

    static class FORE_COLOR {
        public static final int black = 30;
        public static final int red = 31;
        public static final int green = 32;
        public static final int yellow = 33;
        public static final int blue = 34;
        public static final int magenta = 35;
        public static final int cyan = 36;
        public static final int white = 37;

        FORE_COLOR() {
        }
    }

    static class BACKGROUND_COLOR {
        public static final int black = 40;
        public static final int red = 41;
        public static final int green = 42;
        public static final int yellow = 43;
        public static final int blue = 44;
        public static final int magenta = 45;
        public static final int cyan = 46;
        public static final int white = 47;

        BACKGROUND_COLOR() {
        }
    }
}

