/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.tinystruct.system.Event;

public class EventDispatcher {
    private final Map<Class<? extends Event<?>>, List<Consumer<Event<?>>>> handlers = new ConcurrentHashMap();

    private EventDispatcher() {
    }

    public static EventDispatcher getInstance() {
        return InstanceHolder.instance;
    }

    public <E extends Event<?>> void registerHandler(Class<E> eventType, Consumer<E> handler) {
        if (handler != null) {
            this.handlers.computeIfAbsent(eventType, k -> new ArrayList()).add(event -> handler.accept((Event)eventType.cast(event)));
        }
    }

    public void dispatch(Event<?> event) {
        List<Consumer<Event<?>>> eventHandlers = this.handlers.get(event.getClass());
        if (eventHandlers != null) {
            eventHandlers.forEach(handler -> handler.accept(event));
        }
    }

    private static final class InstanceHolder {
        private static final EventDispatcher instance = new EventDispatcher();

        private InstanceHolder() {
        }
    }
}

