/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.handler.MQTTServerHandler;
import org.tinystruct.system.Bootstrap;

public class MQTTServer
extends AbstractApplication
implements Bootstrap {
    private static final Logger logger = Logger.getLogger(MQTTServer.class.getName());

    @Override
    public void init() {
    }

    @Override
    public String version() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ApplicationException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            b.channel(NioServerSocketChannel.class);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("decoder", (ChannelHandler)new MqttDecoder());
                    ch.pipeline().addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                    ch.pipeline().addLast("handler", (ChannelHandler)MQTTServerHandler.INSTANCE);
                }
            });
            ChannelFuture f = b.bind(1883).sync();
            System.out.println("MQTT Broker initiated...");
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
    }
}

