/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Action;
import org.tinystruct.handler.HttpRequestHandler;
import org.tinystruct.handler.HttpStaticFileHandler;
import org.tinystruct.handler.Reforward;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.http.Session;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.Settings;
import org.tinystruct.system.annotation.Action;
import org.tinystruct.system.annotation.Argument;

public class NettyHttpServer
extends AbstractApplication
implements Bootstrap {
    private static final boolean SSL = System.getProperty("ssl") != null;
    private static final int MAX_CONTENT_LENGTH = 102400;
    private final EventLoopGroup bossgroup;
    private final EventLoopGroup workgroup;
    private final Logger logger = Logger.getLogger(NettyHttpServer.class.getName());
    private int port = 8080;

    public NettyHttpServer() {
        if (Epoll.isAvailable()) {
            this.bossgroup = new EpollEventLoopGroup(1);
            this.workgroup = new EpollEventLoopGroup();
        } else {
            this.bossgroup = new NioEventLoopGroup(1);
            this.workgroup = new NioEventLoopGroup();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    @Action(value="start", description="Start up the netty-based http server.", options={@Argument(key="server-port", description="Server port"), @Argument(key="http.proxyHost", description="Proxy host for http"), @Argument(key="http.proxyPort", description="Proxy port for http"), @Argument(key="https.proxyHost", description="Proxy host for https"), @Argument(key="https.proxyPort", description="Proxy port for https")}, example="bin/dispatcher start --import org.tinystruct.system.NettyHttpServer --server-port 777", mode=Action.Mode.CLI)
    public void start() throws ApplicationException {
        if (this.getContext() != null) {
            if (this.getContext().getAttribute("--server-port") != null) {
                this.port = Integer.parseInt(this.getContext().getAttribute("--server-port").toString());
            }
            if (this.getContext().getAttribute("--http.proxyHost") != null && this.getContext().getAttribute("--http.proxyPort") != null) {
                System.setProperty("http.proxyHost", this.getContext().getAttribute("--http.proxyHost").toString());
                System.setProperty("http.proxyPort", this.getContext().getAttribute("--http.proxyPort").toString());
            }
            if (this.getContext().getAttribute("--https.proxyHost") != null && this.getContext().getAttribute("--https.proxyPort") != null) {
                System.setProperty("https.proxyHost", this.getContext().getAttribute("--https.proxyHost").toString());
                System.setProperty("https.proxyPort", this.getContext().getAttribute("--https.proxyPort").toString());
            }
        }
        System.out.println(ApplicationManager.call("--logo", null, Action.Mode.CLI));
        String charsetName = null;
        Settings settings = new Settings();
        if (settings.get("default.file.encoding") != null) {
            charsetName = settings.get("default.file.encoding");
        }
        if (charsetName != null && !charsetName.trim().isEmpty()) {
            System.setProperty("file.encoding", charsetName);
        }
        settings.set("language", "zh_CN");
        if (settings.get("system.directory") == null) {
            settings.set("system.directory", System.getProperty("user.dir"));
        }
        try {
            ApplicationManager.init(settings);
        }
        catch (ApplicationException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        long start = System.currentTimeMillis();
        try {
            SslContext sslCtx;
            if (SSL) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            } else {
                sslCtx = null;
            }
            final int maxContentLength = "".equalsIgnoreCase(this.getConfiguration().get("default.http.max_content_length")) ? 102400 : Integer.parseInt(this.getConfiguration().get("default.http.max_content_length"));
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossgroup, this.workgroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                    }
                    p.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
                    p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(maxContentLength), new ChunkedWriteHandler(), new HttpStaticFileHandler(), new HttpRequestHandler(NettyHttpServer.this.getConfiguration())});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            ChannelFuture future = bootstrap.bind(this.port).sync();
            this.logger.info("Netty server (" + this.port + ") startup in " + (System.currentTimeMillis() - start) + " ms");
            this.getContext().setAttribute("--url", "http://localhost:" + this.port);
            ApplicationManager.call("open", this.getContext(), Action.Mode.CLI);
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void stop() {
        this.bossgroup.shutdownGracefully();
        this.workgroup.shutdownGracefully();
    }

    @Action(value="error", description="Error page")
    public Object exceptionCaught() throws ApplicationException {
        Request request = (Request)this.getContext().getAttribute("HTTP_REQUEST");
        Response response = (Response)this.getContext().getAttribute("HTTP_RESPONSE");
        Reforward reforward = new Reforward(request, response);
        this.setVariable("from", reforward.getFromURL());
        Session session = request.getSession();
        if (session.getAttribute("error") != null) {
            ApplicationException exception = (ApplicationException)session.getAttribute("error");
            String message = exception.getRootCause().getMessage();
            this.setVariable("exception.message", Objects.requireNonNullElse(message, "Unknown error"));
            StackTraceElement[] stackTrace = exception.getStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append(exception).append("\n");
            for (StackTraceElement stackTraceElement : stackTrace) {
                builder.append(stackTraceElement.toString()).append("\n");
            }
            this.logger.severe(builder.toString());
            return this.getVariable("exception.message").getValue().toString();
        }
        reforward.forward();
        return "This request is forbidden!";
    }
}

