/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.redis.RedisDecoder;
import io.netty.handler.logging.LoggingHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Action;
import org.tinystruct.handler.RedisProxyHandler;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.ProxyServer;
import org.tinystruct.system.annotation.Action;
import org.tinystruct.system.annotation.Argument;

public class RedisProxyServer
extends ProxyServer
implements Bootstrap {
    private int port = 6380;
    private String remoteHost = "localhost";
    private int remotePort = 6379;
    private final Logger logger = Logger.getLogger(RedisProxyServer.class.getName());

    @Override
    public void init() {
        this.setTemplateRequired(false);
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    @Action(value="start", description="Start a Tomcat server.", options={@Argument(key="server-port", description="Server port"), @Argument(key="remote-server-host", description="Remote Server host"), @Argument(key="remote-server-port", description="Remote Server port")}, example="bin/dispatcher start --import org.tinystruct.system.RedisProxyServer --server-port 8080", mode=Action.Mode.CLI)
    public void start() throws ApplicationException {
        if (this.getContext() != null) {
            if (this.getContext().getAttribute("--server-port") != null) {
                this.port = Integer.parseInt(this.getContext().getAttribute("--server-port").toString());
            }
            if (this.getContext().getAttribute("--remote-server-port") != null) {
                this.remotePort = Integer.parseInt(this.getContext().getAttribute("--remote-server-port").toString());
            }
            if (this.getContext().getAttribute("--remote-server-host") != null) {
                this.remoteHost = this.getContext().getAttribute("--remote-server-host").toString();
            }
        }
        try {
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossgroup, this.workgroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new RedisDecoder(true)});
                    ch.pipeline().addLast(new ChannelHandler[]{new RedisProxyHandler(RedisProxyServer.this.remoteHost, RedisProxyServer.this.remotePort)});
                }
            }).childOption(ChannelOption.AUTO_READ, (Object)false);
            ChannelFuture future = bootstrap.bind(this.port).sync();
            this.logger.info("Proxy server(" + this.port + ") started.");
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void stop() {
        this.bossgroup.shutdownGracefully();
        this.workgroup.shutdownGracefully();
    }
}

