/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class Resource {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    private ResourceBundle resource;
    private static final Map<String, Resource> map = new ConcurrentHashMap<String, Resource>();

    private Resource() {
    }

    private Resource(Locale locale) {
        this.resource = ResourceBundle.getBundle("languages/lang", locale);
    }

    private Resource(String language, String country) {
        this.resource = ResourceBundle.getBundle("languages/lang", new Locale(language, country));
    }

    public static Resource getInstance(Locale locale) {
        if (map.containsKey(locale.toString())) {
            return map.get(locale.toString());
        }
        Resource instance = new Resource(locale);
        map.put(locale.toString(), instance);
        return instance;
    }

    public static Resource getInstance(String language) {
        if (map.containsKey(language)) {
            return map.get(language);
        }
        String[] lang = language.split("_");
        Resource instance = new Resource(lang[0], lang[1]);
        map.put(language, instance);
        return instance;
    }

    public String getLocaleString(String field) {
        try {
            return this.resource.getString(field);
        }
        catch (Exception e) {
            logger.info(e.getMessage() + " key:" + field);
            return "";
        }
    }
}

