/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.system.Configuration;

public class Settings
implements Configuration<String> {
    private static final long serialVersionUID = 8348657988449703373L;
    private static final String DEFAULT_FILE = "application.properties";
    private final Properties properties;
    private final String file;

    public Settings() {
        this(DEFAULT_FILE);
    }

    public Settings(String file) {
        this.file = file;
        this.properties = SingletonHolder.INSTANCE.getProperties(file);
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String get(String property) {
        String value = this.properties.getProperty(property);
        if (value != null && value.startsWith("$_")) {
            String envVariableName = value.substring(2).toUpperCase();
            return System.getenv(envVariableName) != null ? System.getenv(envVariableName) : "";
        }
        try {
            if (value != null) {
                byte[] bytes = value.getBytes(StandardCharsets.ISO_8859_1);
                return new String(bytes, StandardCharsets.UTF_8).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void set(String key, String value) {
        this.properties.put(key, value);
        this.saveProperties();
    }

    @Override
    public void remove(String key) {
        this.properties.remove(key);
        this.saveProperties();
    }

    @Override
    public Set<String> propertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Override
    public String getOrDefault(String key, String value) {
        return this.get(key).isEmpty() ? value : this.get(key);
    }

    @Override
    public void setIfAbsent(String key, String value) {
        if (!this.properties.containsKey(key)) {
            this.set(key, value);
        }
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    public void saveProperties() {
        URL resource = Settings.class.getClassLoader().getResource(this.file != null ? this.file : DEFAULT_FILE);
        if (null != resource) {
            URI uri;
            try {
                uri = resource.toURI();
            }
            catch (URISyntaxException e) {
                throw new ApplicationRuntimeException(e.getMessage());
            }
            String path = uri.getPath();
            if (path != null) {
                try (FileOutputStream outputStream = new FileOutputStream(path);
                     BufferedOutputStream out = new BufferedOutputStream(outputStream);){
                    this.properties.store(out, "#tinystruct configuration");
                }
                catch (FileNotFoundException e) {
                    throw new ApplicationRuntimeException("File not found:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("Error saving properties: " + e.getMessage(), e);
                }
            }
        }
    }

    private static final class SingletonHolder {
        public static final SingletonHolder INSTANCE = new SingletonHolder();
        private final Properties properties = new Properties();

        private SingletonHolder() {
        }

        private Properties getProperties(String fileName) {
            try (InputStream in = Settings.class.getClassLoader().getResourceAsStream(fileName);){
                if (in != null) {
                    this.properties.load(in);
                } else {
                    Logger.getLogger(Settings.class.getName()).warning("No settings loaded.");
                }
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Error loading properties: " + e.getMessage(), e);
            }
            return this.properties;
        }
    }
}

