/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Action;
import org.tinystruct.handler.DefaultHandler;
import org.tinystruct.handler.Reforward;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.http.Session;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.Settings;
import org.tinystruct.system.annotation.Action;
import org.tinystruct.system.annotation.Argument;

public class TomcatServer
extends AbstractApplication
implements Bootstrap {
    private final Logger logger = Logger.getLogger(TomcatServer.class.getName());
    private boolean started = false;

    @Override
    public void init() {
        this.setTemplateRequired(false);
    }

    @Override
    @Action(value="start", description="Start a Tomcat server.", options={@Argument(key="server-port", description="Server port"), @Argument(key="http.proxyHost", description="Proxy host for http"), @Argument(key="http.proxyPort", description="Proxy port for http"), @Argument(key="https.proxyHost", description="Proxy host for https"), @Argument(key="https.proxyPort", description="Proxy port for https")}, example="bin/dispatcher start --import org.tinystruct.system.TomcatServer --server-port 777", mode=Action.Mode.CLI)
    public void start() throws ApplicationException {
        if (this.started) {
            return;
        }
        String charsetName = null;
        Settings settings = new Settings();
        if (settings.get("default.file.encoding") != null) {
            charsetName = settings.get("default.file.encoding");
        }
        if (charsetName != null && !charsetName.trim().isEmpty()) {
            System.setProperty("file.encoding", charsetName);
        }
        settings.set("language", "zh_CN");
        if (settings.get("system.directory") == null) {
            settings.set("system.directory", System.getProperty("user.dir"));
        }
        try {
            ApplicationManager.init(settings);
        }
        catch (ApplicationException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        int webPort = 8080;
        if (this.getContext() != null) {
            if (this.getContext().getAttribute("--http.proxyHost") != null && this.getContext().getAttribute("--http.proxyPort") != null) {
                System.setProperty("http.proxyHost", this.getContext().getAttribute("--http.proxyHost").toString());
                System.setProperty("http.proxyPort", this.getContext().getAttribute("--http.proxyPort").toString());
            }
            if (this.getContext().getAttribute("--https.proxyHost") != null && this.getContext().getAttribute("--https.proxyPort") != null) {
                System.setProperty("https.proxyHost", this.getContext().getAttribute("--https.proxyHost").toString());
                System.setProperty("https.proxyPort", this.getContext().getAttribute("--https.proxyPort").toString());
            }
            if (this.getContext().getAttribute("--server-port") != null) {
                webPort = Integer.parseInt(this.getContext().getAttribute("--server-port").toString());
            }
        }
        System.out.println(ApplicationManager.call("--logo", null, Action.Mode.CLI));
        long start = System.currentTimeMillis();
        String webappDirLocation = ".";
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(webPort);
        tomcat.setAddDefaultWebXmlToWebapp(false);
        tomcat.getConnector();
        Host host = tomcat.getHost();
        host.setConfigClass(DefaultContextConfig.class.getName());
        host.setAutoDeploy(false);
        try {
            DefaultContextConfig config = new DefaultContextConfig();
            String docBase = new File(".").getAbsolutePath();
            Context ctx = tomcat.addWebapp(host, "", docBase, (LifecycleListener)config);
            this.initWebappDefaults(ctx);
            this.logger.info("Configuring app with basedir: " + docBase);
            Class<DefaultHandler> filterClass = DefaultHandler.class;
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterClass(filterClass.getName());
            filterDef.setFilterName(filterClass.getSimpleName());
            ctx.addFilterDef(filterDef);
            FilterMap filterMap = new FilterMap();
            filterMap.setFilterName(filterClass.getSimpleName());
            filterMap.addURLPattern("/");
            ctx.addFilterMap(filterMap);
            tomcat.start();
            this.started = true;
            this.logger.info("Tomcat server (" + webPort + ") startup in " + (System.currentTimeMillis() - start) + " ms");
            this.getContext().setAttribute("--url", "http://localhost:" + webPort);
            ApplicationManager.call("open", this.getContext(), Action.Mode.CLI);
            tomcat.getServer().await();
        }
        catch (LifecycleException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    private void initWebappDefaults(Context ctx) {
        Wrapper servlet = Tomcat.addServlet((Context)ctx, (String)"default", (String)"org.apache.catalina.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        ctx.addServletMappingDecoded("/", "default");
        ctx.setSessionTimeout(30);
        Tomcat.addDefaultMimeTypeMappings((Context)ctx);
    }

    @Override
    public void stop() {
    }

    @Action(value="error", description="Error page")
    public Object exceptionCaught() throws ApplicationException {
        Request request = (Request)this.getContext().getAttribute("HTTP_REQUEST");
        Response response = (Response)this.getContext().getAttribute("HTTP_RESPONSE");
        Reforward reforward = new Reforward(request, response);
        this.setVariable("from", reforward.getFromURL());
        Session session = request.getSession();
        if (session.getAttribute("error") != null) {
            ApplicationException exception = (ApplicationException)session.getAttribute("error");
            String message = exception.getRootCause().getMessage();
            this.setVariable("exception.message", Objects.requireNonNullElse(message, "Unknown error"));
            StackTraceElement[] stackTrace = exception.getStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append(exception).append("\n");
            for (StackTraceElement stackTraceElement : stackTrace) {
                builder.append(stackTraceElement.toString()).append("\n");
            }
            this.logger.severe(builder.toString());
            return this.getVariable("exception.message").getValue().toString();
        }
        reforward.forward();
        return "This request is forbidden!";
    }

    @Override
    public String version() {
        return "";
    }

    static class DefaultContextConfig
    extends ContextConfig {
        private static final Log log = LogFactory.getLog(ContextConfig.class);

        DefaultContextConfig() {
        }

        protected synchronized void configureStart() {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.start"));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.xmlSettings", new Object[]{this.context.getName(), this.context.getXmlValidation(), this.context.getXmlNamespaceAware()}));
            }
            if (!this.skipWebXmlFileScan()) {
                this.webConfig();
            }
            if (!this.context.getIgnoreAnnotations()) {
                this.applicationAnnotationsConfig();
            }
            if (this.ok) {
                this.validateSecurityRoles();
            }
            if (this.ok) {
                this.authenticatorConfig();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Pipeline Configuration:");
                Pipeline pipeline = this.context.getPipeline();
                Valve[] valves = null;
                if (pipeline != null) {
                    valves = pipeline.getValves();
                }
                if (valves != null) {
                    for (Valve valve : valves) {
                        log.debug((Object)("  " + valve.getClass().getName()));
                    }
                }
                log.debug((Object)"======================");
            }
            if (this.ok) {
                this.context.setConfigured(true);
            } else {
                log.error((Object)sm.getString("contextConfig.unavailable"));
                this.context.setConfigured(false);
            }
        }

        public boolean skipWebXmlFileScan() {
            return true;
        }
    }
}

