/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.chain;

import java.util.ArrayList;
import java.util.List;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.Processor;

public abstract class AbstractProcessorChain<T>
extends AbstractApplication {
    private final List<Processor<T>> processors = new ArrayList<Processor<T>>();

    public void addProcessor(Processor<T> processor) {
        this.processors.add(processor);
    }

    public T process(T input) {
        T currentData = input;
        for (Processor<T> processor : this.processors) {
            try {
                currentData = processor.process(currentData);
            }
            catch (ApplicationException e) {
                throw new RuntimeException(e);
            }
        }
        return currentData;
    }

    @Override
    public String version() {
        return "";
    }
}

