/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.scheduling;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.tinystruct.system.scheduling.ScheduleIterator;
import org.tinystruct.system.scheduling.SchedulerTask;

public class Scheduler {
    private static final Scheduler INSTANCE = new Scheduler(true);
    private final Timer timer;

    public Scheduler(boolean isDaemon) {
        this.timer = new Timer(isDaemon);
    }

    public static Scheduler getInstance() {
        return INSTANCE;
    }

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(final SchedulerTask schedulerTask, final ScheduleIterator iterator) {
        Object object = SchedulerTask.lock;
        synchronized (object) {
            final Scheduler scheduler = this;
            Date time = iterator.getTime();
            if (time == null) {
                schedulerTask.cancel();
            } else {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        schedulerTask.start();
                        if (schedulerTask.next()) {
                            scheduler.schedule(schedulerTask, iterator.next());
                        }
                    }
                }, time);
            }
        }
    }

    public void schedule(TimerTask task, ScheduleIterator iterator, long period) {
        this.timer.scheduleAtFixedRate(task, iterator.getTime(), period);
    }

    public void remove(TimerTask task) {
        task.cancel();
    }
}

