/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.security;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.AbstractApplication;
import org.tinystruct.system.annotation.Action;

public class KeyPairGenerator
extends AbstractApplication {
    private static final Logger logger = Logger.getLogger(KeyPairGenerator.class.getName());

    @Override
    public void init() {
        this.setTemplateRequired(false);
    }

    @Action(value="generateKeyPair")
    public void getKeyPair() {
        String publicKeyFile = "/ca.pub";
        String privateKeyFile = "/ca.pri";
        if (this.getContext().getAttribute("--public-key") != null) {
            publicKeyFile = this.getContext().getAttribute("--public-key").toString();
        }
        if (this.getContext().getAttribute("--private-key") != null) {
            privateKeyFile = this.getContext().getAttribute("--private-key").toString();
        }
        if (this.getContext().getAttribute("--password") == null) {
            logger.info("Password is required. please use --password PASSWORD option.");
            return;
        }
        String password = this.getContext().getAttribute("--password").toString();
        try {
            java.security.KeyPairGenerator keyPairGenerator = java.security.KeyPairGenerator.getInstance("RSA");
            SecureRandom secureRandom = new SecureRandom(password.getBytes());
            keyPairGenerator.initialize(2048, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            byte[] privateKey = keyPair.getPrivate().getEncoded();
            byte[] publicKey = keyPair.getPublic().getEncoded();
            Files.writeString(Paths.get("src", "main", "resources", publicKeyFile), (CharSequence)new String(publicKey), new OpenOption[0]);
            Files.writeString(Paths.get("src", "main", "resources", privateKeyFile), (CharSequence)new String(privateKey), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public String version() {
        return null;
    }
}

