/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.ActionRegistry;
import org.tinystruct.application.SharedVariables;
import org.tinystruct.application.Template;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.TextFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DefaultTemplate
implements Template {
    private static final String HTML5_DOCTYPE = "<!DOCTYPE html>";
    private static final String HTML4_TRANSITIONAL_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    private static final String HTML4_STRICT_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String XHTML1_TRANSITIONAL_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final String XHTML1_STRICT_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private static final Set<String> voidElements = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr", "path"));
    private static final String engineName = "JavaScript";
    private final ScriptEngine engine;
    final Application app;
    final ActionRegistry registry = ActionRegistry.getInstance();
    Map<String, Variable<?>> variables;
    InputStream in;
    String view;

    public DefaultTemplate(Application app, InputStream in) {
        this.app = app;
        this.engine = SingletonHolder.manager.getEngineByName(engineName);
        if (null != this.engine) {
            this.engine.put("self", this.app);
        }
        this.in = in;
        this.variables = SharedVariables.getInstance(this.app.getLocale().toString()).getVariables();
    }

    public DefaultTemplate(Application app, InputStream in, Map<String, Variable<?>> variables) {
        this(app, in);
        HashMap tmp = new HashMap();
        tmp.putAll(this.variables);
        tmp.putAll(variables);
        this.variables = tmp;
    }

    public DefaultTemplate(Application app, String view) {
        this.app = app;
        this.view = view;
        this.engine = SingletonHolder.manager.getEngineByName(engineName);
        if (null != this.engine) {
            this.engine.put("self", this.app);
            this.engine.put("self.toString", "Please don't execute like this.");
        }
        this.variables = SharedVariables.getInstance(this.app.getLocale().toString()).getVariables();
    }

    static void stripEmptyTextNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            boolean condition;
            Node child = children.item(i);
            boolean bl = condition = child.getNodeType() == 3 && child.getTextContent().trim().isEmpty();
            if (condition) {
                child.getParentNode().removeChild(child);
                --i;
            }
            DefaultTemplate.stripEmptyTextNode(child);
        }
    }

    @Override
    public String getName() {
        return "javax.script.name";
    }

    @Override
    public Variable<?> getVariable(String arg0) {
        return this.variables.get(arg0);
    }

    @Override
    public Map<String, Variable<?>> getVariables() {
        return this.variables;
    }

    private Document parseDocument(String content) throws ApplicationException {
        Document document;
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(in);
            DefaultTemplate.stripEmptyTextNode(doc);
            document = doc;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        ((InputStream)in).close();
        return document;
    }

    private void processJavaScript(Document doc) throws ApplicationException {
        NodeList js;
        int length;
        if (this.engine != null && (length = (js = doc.getElementsByTagName("javascript")).getLength()) > 0) {
            try {
                ScriptContext context = this.engine.getContext();
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter((Writer)sw, true);
                context.setWriter(writer);
                for (int i = 0; i < length; ++i) {
                    Node node = js.item(i);
                    Object r = this.engine.eval(node.getTextContent());
                    String result = r != null ? String.valueOf(r) : sw.toString();
                    Text t = doc.createTextNode(result);
                    Node p = node.getParentNode();
                    p.appendChild(t);
                    p.replaceChild(t, node);
                }
                ((Writer)writer).close();
            }
            catch (ScriptException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException(e);
            }
        }
    }

    @Override
    public String parse() throws ApplicationException {
        Configuration<String> config = this.app.getConfiguration();
        if (config == null) {
            throw new ApplicationException("The configuration for the app has not been set.");
        }
        if (this.view == null) {
            TextFileLoader loader = new TextFileLoader(this.in);
            loader.setCharset(config.get("charset"));
            try {
                this.view = loader.getContent().toString();
            }
            catch (ApplicationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        if (!this.view.trim().isEmpty()) {
            String view = DefaultTemplate.preprocess(this.view);
            if (view.contains("<javascript>")) {
                Document doc = this.parseDocument(view);
                this.processJavaScript(doc);
                DOMSource domSource = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                writer.write("<!DOCTYPE html>\r\n");
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                try {
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("indent", "no");
                    transformer.setOutputProperty("media-type", "xml");
                    transformer.setOutputProperty("cdata-section-elements", "script");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    transformer.transform(domSource, result);
                }
                catch (TransformerException e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
                this.view = writer.toString();
            } else {
                this.view = view;
            }
            Set<Map.Entry<String, Variable<?>>> sets = this.variables.entrySet();
            for (Map.Entry<String, Variable<?>> v : sets) {
                Variable<?> variable = v.getValue();
                if (variable.getType() == DataType.ARRAY) continue;
                String value = variable.getValue().toString().replace("&", "&amp;");
                this.view = this.view.replace(v.getKey(), value);
            }
            this.registry.paths().forEach(path -> {
                String v = this.generateLink((String)path);
                this.view = this.view.replace("[%LINK:" + path + "%]", v);
            });
            return this.view;
        }
        return this.view;
    }

    public String generateLink(String path) {
        String baseUrl = this.app.getContext() != null && this.app.getContext().getAttribute("HTTP_HOST") != null ? this.app.getContext().getAttribute("HTTP_HOST").toString() : this.app.getConfiguration().get("default.base_url");
        if (path != null) {
            return baseUrl + path + "&lang=" + this.app.getLocale().toLanguageTag();
        }
        return "#";
    }

    @Override
    public void setVariable(Variable<?> arg0) {
        this.variables.put(arg0.getName(), arg0);
    }

    private static String preprocess(String html) {
        String[] tags = ((String)html).split("<|</");
        StringBuilder autoClosedHtml = new StringBuilder();
        LinkedHashSet<String> openTags = new LinkedHashSet<String>();
        boolean skip = false;
        for (String tag : tags) {
            boolean isSelfClosing;
            if (tag.startsWith("/script>")) {
                skip = false;
            }
            if (skip) {
                autoClosedHtml.append("<").append(tag);
                continue;
            }
            if (tag.trim().isEmpty()) continue;
            int endIndex = tag.indexOf(">");
            if (endIndex == -1) {
                autoClosedHtml.append("<").append(tag);
                continue;
            }
            String tagName = tag.substring(0, endIndex).split("\\s|/>")[0].toLowerCase();
            boolean bl = isSelfClosing = tag.endsWith("/>") || voidElements.contains(tagName);
            if (!(tagName.isEmpty() || tag.startsWith("!") || tag.startsWith("/") || isSelfClosing)) {
                if (tagName.indexOf(32) != -1) {
                    openTags.add(tagName.substring(0, tagName.indexOf(32)));
                } else if (tagName.indexOf(47) != -1) {
                    openTags.add(tagName.substring(0, tagName.indexOf(47)));
                } else {
                    openTags.add(tagName);
                }
            } else if (!tagName.isEmpty() && tag.startsWith("/")) {
                openTags.remove(tagName.substring(1));
            }
            if (tag.startsWith("script")) {
                skip = true;
            }
            autoClosedHtml.append("<").append(tag);
        }
        for (String openTag : openTags) {
            if (voidElements.contains(openTag)) continue;
            autoClosedHtml.append("</").append(openTag).append(">");
        }
        html = autoClosedHtml.toString();
        boolean hasHtmlTag = ((String)html).toLowerCase().contains("<html");
        boolean hasBodyTag = ((String)html).toLowerCase().contains("<body");
        if (!hasHtmlTag) {
            html = "<html>" + (String)html + "</html>";
        }
        if (!hasBodyTag) {
            html = ((String)html).replaceFirst("(<html[^>]*>)", "$1<body>").replaceFirst("(</html>)", "</body>$1");
        }
        StringBuilder processed = new StringBuilder();
        int pos = 0;
        while (pos < ((String)html).length()) {
            int tagStart = ((String)html).indexOf("<", pos);
            if (tagStart == -1) {
                processed.append(((String)html).substring(pos));
                break;
            }
            processed.append((CharSequence)html, pos, tagStart);
            int tagEnd = ((String)html).indexOf(">", tagStart);
            if (tagEnd == -1) {
                processed.append(((String)html).substring(tagStart));
                break;
            }
            String tag = ((String)html).substring(tagStart, tagEnd + 1);
            String tagName = tag.substring(1).split("\\s|>|/>")[0].toLowerCase();
            if (tagName.equalsIgnoreCase("script")) {
                String end = "</script>";
                String tmp = ((String)html).substring(tagEnd + 1);
                String value = tmp.substring(0, tmp.indexOf(end));
                processed.append(tag);
                if (!value.trim().isEmpty()) {
                    if (!value.trim().startsWith("//<![CDATA[")) {
                        processed.append("\n").append("//<![CDATA[\n");
                    }
                    processed.append(value.trim());
                    if (!value.trim().endsWith("//]]>")) {
                        processed.append("\n").append("//]]>\n");
                    }
                }
                processed.append(end);
                pos = tagEnd + 1 + value.length() + end.length();
                continue;
            }
            if (voidElements.contains(tagName)) {
                if (!tag.endsWith("/>")) {
                    processed.append(tag, 0, tag.length() - 1).append(" />");
                } else {
                    processed.append(tag, 0, tag.length() - 2).append(" />");
                }
            } else {
                processed.append(tag);
            }
            pos = tagEnd + 1;
        }
        if (!((String)html).toLowerCase().contains("<!doctype")) {
            return "<!DOCTYPE html>\n" + String.valueOf(processed);
        }
        return processed.toString();
    }

    private static final class SingletonHolder {
        static final ScriptEngineManager manager = new ScriptEngineManager();

        private SingletonHolder() {
        }
    }

    public static enum DocumentType {
        XML,
        HTML5,
        HTML4_TRANSITIONAL,
        HTML4_STRICT,
        XHTML1_TRANSITIONAL,
        XHTML1_STRICT;

    }
}

