/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.template;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.ActionRegistry;
import org.tinystruct.application.Context;
import org.tinystruct.application.SharedVariables;
import org.tinystruct.application.Template;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.TextFileLoader;

public class PlainText
implements Template {
    private final Application app;
    private Map<String, Variable<?>> variables;
    private InputStream in;
    private String text;
    private final ActionRegistry registry = ActionRegistry.getInstance();

    public PlainText(Application app, InputStream in) {
        this.app = app;
        this.in = in;
        this.variables = SharedVariables.getInstance(this.app.getLocale().toString()).getVariables();
    }

    public PlainText(Application app, String text) {
        this.app = app;
        this.text = text;
        this.variables = SharedVariables.getInstance(this.app.getLocale().toString()).getVariables();
    }

    public PlainText(Application app, String text, Map<String, Variable<?>> variables) {
        this(app, text);
        HashMap tmp = new HashMap();
        tmp.putAll(this.variables);
        tmp.putAll(variables);
        this.variables = tmp;
    }

    @Override
    public String getName() {
        return "PLAIN_TEXT";
    }

    @Override
    public Variable<?> getVariable(String arg0) {
        return this.variables.get(arg0);
    }

    @Override
    public Map<String, Variable<?>> getVariables() {
        return this.variables;
    }

    @Override
    public String parse() throws ApplicationException {
        Configuration<String> config = this.app.getConfiguration();
        if (this.text == null) {
            TextFileLoader loader = new TextFileLoader(this.in);
            loader.setCharset(config.get("charset"));
            try {
                this.text = loader.getContent().toString();
            }
            catch (ApplicationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        Set<Map.Entry<String, Variable<?>>> sets = this.variables.entrySet();
        Iterator<Map.Entry<String, Variable<?>>> iterator = sets.iterator();
        Context ctx = this.app.getContext();
        while (iterator.hasNext()) {
            Map.Entry<String, Variable<?>> v = iterator.next();
            Variable<?> variable = v.getValue();
            if (variable.getType() == DataType.ARRAY) continue;
            String value = variable.getValue().toString();
            value = value.replaceAll("&", "&amp;");
            this.text = this.text.replace(v.getKey(), value);
        }
        this.registry.paths().forEach(path -> {
            String v = this.generateLink((String)path);
            this.text = this.text.replace("[%LINK:" + path + "%]", v);
        });
        return this.text;
    }

    public String generateLink(String path) {
        String baseUrl = this.app.getContext() != null && this.app.getContext().getAttribute("HTTP_HOST") != null ? this.app.getContext().getAttribute("HTTP_HOST").toString() : this.app.getConfiguration().get("default.base_url");
        if (path != null) {
            return baseUrl + path + "&lang=" + this.app.getLocale().toLanguageTag();
        }
        return "#";
    }

    @Override
    public void setVariable(Variable<?> arg0) {
        this.variables.put(arg0.getName(), arg0);
    }
}

