/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.File;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;
import org.tinystruct.system.util.Local;

public class ClassInfo {
    private final Object object;
    private final Configuration<String> properties;
    private final String default_application_path;

    public ClassInfo() throws ApplicationException {
        this.object = this;
        this.properties = new Settings();
        this.default_application_path = !this.properties.get("system.directory").trim().isEmpty() ? new Local(this.properties.get("system.directory")).getPath() : new Local(ClassInfo.getApplicationPath(this.getClass())).getPath();
    }

    public ClassInfo(Object object) throws ApplicationException {
        this.object = object;
        this.properties = new Settings();
        this.default_application_path = !this.properties.get("system.directory").trim().isEmpty() ? new Local(this.properties.get("system.directory")).getPath() : new Local(ClassInfo.getApplicationPath(this.getClass())).getPath();
    }

    public String getClassName() {
        return this.object.getClass().getName();
    }

    public String getSimpleName() {
        String className = this.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public String getClassRootPath() {
        return new Local(this.default_application_path + "WEB-INF" + File.separatorChar + "classes").getPath();
    }

    public String getClassPath() {
        String className = this.getClassName().replace('.', File.separatorChar);
        className = className.substring(0, className.lastIndexOf(File.separatorChar) + 1);
        return className;
    }

    public static String getApplicationPath(Class<?> _class) {
        return _class.getProtectionDomain().getCodeSource().getLocation().getPath();
    }
}

