/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.File;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinystruct.http.Cookie;

public class StringUtilities
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final char[] HTML = "<>'\"".toCharArray();
    private String raw;

    public StringUtilities(String raw) {
        this.raw = raw;
    }

    public StringUtilities(byte[] bytes) {
        this.raw = new String(bytes);
    }

    public static String getURL(String url) {
        if (((String)url).toLowerCase().indexOf("http://") == 0 && ((String)url).toLowerCase().indexOf("mms://") == 0 && ((String)url).toLowerCase().indexOf("rtsp://") == 0 && ((String)url).toLowerCase().indexOf("https://") == 0) {
            url = "http://" + (String)url;
        }
        return url;
    }

    public static boolean isAbsoluteURL(String url) {
        return url.toLowerCase().indexOf("http://") != 0 || url.toLowerCase().indexOf("mms://") != 0 || url.toLowerCase().indexOf("rtsp://") != 0 || url.toLowerCase().indexOf("https://") != 0;
    }

    public static String leftPadding(String raw, int len, char replacement) {
        return String.format("%" + len + "s", raw).replace(' ', replacement);
    }

    public static String rightPadding(String raw, int len, char replacement) {
        return String.format("%-" + len + "s", raw).replace(' ', replacement);
    }

    public static String htmlSpecialChars(String value) {
        int len = value.length();
        if (len > 0) {
            StringBuilder v = new StringBuilder(value);
            block7: for (int i = 0; i < v.length(); ++i) {
                switch (v.charAt(i)) {
                    case '&': {
                        String replacement = "&amp;";
                        v.deleteCharAt(i);
                        v.insert(i, replacement);
                        i += replacement.length() - 1;
                        continue block7;
                    }
                    case '<': {
                        String replacement = "&lt;";
                        v.deleteCharAt(i);
                        v.insert(i, replacement);
                        i += replacement.length() - 1;
                        continue block7;
                    }
                    case '>': {
                        String replacement = "&gt;";
                        v.deleteCharAt(i);
                        v.insert(i, replacement);
                        i += replacement.length() - 1;
                        continue block7;
                    }
                    case '\'': {
                        String replacement = "&#39;";
                        v.deleteCharAt(i);
                        v.insert(i, replacement);
                        i += replacement.length() - 1;
                        continue block7;
                    }
                    case '\"': {
                        String replacement = "&#34;";
                        v.deleteCharAt(i);
                        v.insert(i, replacement);
                        i += replacement.length() - 1;
                        continue block7;
                    }
                }
            }
            return v.toString();
        }
        return value;
    }

    public static boolean safe(String string) {
        return new StringUtilities(string).safe();
    }

    public static String leave(String string, int length) {
        char sub;
        if (string.trim().isEmpty()) {
            return "";
        }
        if (string.length() <= length) {
            return string;
        }
        do {
            sub = string.charAt(length++);
        } while (string.indexOf(62) != -1 && sub != '>');
        return string.substring(0, length) + "...";
    }

    public static String sign(String string, String substring) {
        StringBuilder temp = new StringBuilder();
        String color_start = "<b>";
        String color_end = "</b>";
        int index = 0;
        int length = substring.length();
        StringUtilities s = new StringUtilities(string);
        while (true) {
            int position;
            if ((position = s.stringAt(substring, index)) == -1) break;
            temp.append(string, index, position);
            index = position + length;
            temp.append(color_start).append(string, position, index).append(color_end);
        }
        temp.append(string.substring(index));
        return temp.toString();
    }

    public static String linefeed(String string, String delimiter) {
        return new StringUtilities(string).linefeed(delimiter);
    }

    public static String linefeed(String string, char delimiter) {
        return new StringUtilities(string).linefeed(delimiter);
    }

    public static String getRealPath(String FileName) {
        String path = new File(FileName).getAbsolutePath();
        int length = path.length();
        return path.substring(0, length - FileName.length());
    }

    public static String getWebRoot(String FileName) {
        String path = new File(FileName).getAbsolutePath();
        if (!path.contains("WEB-INF")) {
            return "";
        }
        return path.substring(0, path.indexOf("WEB-INF"));
    }

    public static boolean isValid(String parameters) {
        boolean isValid = false;
        if (parameters != null) {
            StringBuilder s2 = new StringBuilder();
            for (int i = 0; i < parameters.length(); ++i) {
                if (parameters.charAt(i) == ',' || i == parameters.length() - 1) {
                    if (i == parameters.length() - 1 && parameters.charAt(i) != ',') {
                        s2.append(parameters.charAt(i));
                    }
                    isValid = !s2.toString().trim().isEmpty();
                    s2 = new StringBuilder();
                    continue;
                }
                s2.append(parameters.charAt(i));
            }
        }
        return isValid;
    }

    public static String setCharToLower(String s, int index) {
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i != index) continue;
            charArray[i] = Character.toLowerCase(charArray[i]);
        }
        return String.valueOf(charArray);
    }

    public static String setCharToUpper(String s, int index) {
        char[] charArray = s.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i != index) continue;
            charArray[i] = Character.toUpperCase(charArray[i]);
        }
        return String.valueOf(charArray);
    }

    public static String setCharToUpper(String s, char afterChar) {
        char[] charArray = s.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i++] != afterChar) continue;
            if (i >= charArray.length) break;
            charArray[i] = Character.toUpperCase(charArray[i]);
        }
        return String.valueOf(charArray);
    }

    public static Cookie getCookieByName(Cookie[] cookies, String name) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].name().equalsIgnoreCase(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    public static String escape(String raw) {
        int len = raw.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder buffer = new StringBuilder(bufLen);
        block9: for (int x = 0; x < len; ++x) {
            char c = raw.charAt(x);
            if (c >= '<' && c < '\u007f') {
                if (c == '\\') {
                    buffer.append('\\').append('\\');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    buffer.append(' ');
                    continue block9;
                }
                case '\t': {
                    buffer.append('\\').append('t');
                    continue block9;
                }
                case '\n': {
                    buffer.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    buffer.append('\\').append('r');
                    continue block9;
                }
                case '\f': {
                    buffer.append('\\').append('f');
                    continue block9;
                }
                case '!': 
                case '#': 
                case ':': {
                    buffer.append(c);
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(StringUtilities.toHex(c >> 12 & 0xF));
                        buffer.append(StringUtilities.toHex(c >> 8 & 0xF));
                        buffer.append(StringUtilities.toHex(c >> 4 & 0xF));
                        buffer.append(StringUtilities.toHex(c & 0xF));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String nospace(String raw) {
        return StringUtilities.remove(raw, ' ');
    }

    public static String remove(String raw, char ch) {
        StringBuilder buffer = new StringBuilder();
        int position = 0;
        while (position < raw.length()) {
            char currentChar;
            if ((currentChar = raw.charAt(position++)) == ch) continue;
            buffer.append(currentChar);
        }
        return buffer.toString();
    }

    public String getString() {
        return this.raw;
    }

    public String replace(char res, String des) {
        if (this.raw == null) {
            return "";
        }
        char[] temp = this.raw.toCharArray();
        StringBuilder buffer = new StringBuilder();
        for (char c : temp) {
            if (c == res) {
                buffer.append(des);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public boolean safe() {
        for (char c : this.HTML) {
            if (this.raw.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public String leave(int length) {
        char sub;
        if (this.isNull()) {
            return "";
        }
        if (this.raw.length() <= length) {
            return this.raw;
        }
        do {
            sub = this.raw.charAt(length++);
        } while (this.raw.indexOf(62) != -1 && sub != '>');
        return this.raw.substring(0, length) + "...";
    }

    public boolean isNull() {
        return this.raw.trim().isEmpty();
    }

    public boolean isNaN() {
        for (int i = 0; i < this.raw.length(); ++i) {
            char c = this.raw.charAt(i);
            if (c < '0' || c > '9') continue;
            return true;
        }
        return false;
    }

    public boolean isLetter() {
        for (int i = 0; i < this.raw.length(); ++i) {
            char c = this.raw.charAt(i);
            if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue;
            return true;
        }
        return false;
    }

    public int stringAt(String substring, int index) {
        return this.raw.toLowerCase().indexOf(substring.toLowerCase(), index);
    }

    public String linefeed(String end) {
        StringBuilder htmlcode = new StringBuilder();
        int index = 0;
        while (true) {
            int position;
            if ((position = this.raw.indexOf(13, index)) == -1) break;
            htmlcode.append(this.raw, index, position);
            index = position + 2;
            htmlcode.append(end);
        }
        htmlcode.append(this.raw.substring(index));
        return htmlcode.toString();
    }

    public String linefeed(char delimiter) {
        char[] ch;
        StringBuilder htmlCode = new StringBuilder();
        for (char c : ch = this.raw.toCharArray()) {
            if (c == '\r') {
                htmlCode.append(delimiter);
                continue;
            }
            htmlCode.append(c);
        }
        return htmlCode.toString();
    }

    public String hideHTML(int length) {
        if (this.isNull()) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        Pattern pattern = Pattern.compile("<br>|<BR>|<br />|<br/><BR />|<BR/>");
        Matcher matcher = pattern.matcher(this.raw);
        this.raw = matcher.replaceAll(String.valueOf('\n'));
        boolean flag = false;
        int k = 0;
        for (int i = 0; i < this.raw.length() && k <= length - 1; ++i) {
            char now = this.raw.charAt(i);
            if (now == '<' && !flag) {
                flag = true;
                continue;
            }
            if (now == '>' && flag) {
                flag = false;
                continue;
            }
            if (flag) continue;
            if (now == '\n' && this.raw.charAt(i + 1) != '<') {
                text.append("<BR />");
                continue;
            }
            text.append(now);
            ++k;
        }
        text.append("...");
        return text.toString();
    }

    public String removeTrailingSlash() {
        int i;
        while ((i = this.raw.lastIndexOf(47)) != -1 && i == (this.raw + "/").lastIndexOf("//")) {
            this.raw = this.raw.substring(0, i);
        }
        return this.raw;
    }
}

