/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.tinystruct.ApplicationException;

public class TextFileLoader {
    private File file;
    private InputStream inputStream;
    private String charsetName = "utf-8";

    public TextFileLoader() {
    }

    public TextFileLoader(File file) {
        this.file = file;
    }

    public TextFileLoader(String fileName) {
        this.file = new File(fileName);
    }

    public TextFileLoader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setCharset(String charsetName) {
        this.charsetName = charsetName;
    }

    public StringBuilder getContent() throws ApplicationException {
        StringBuilder content;
        block10: {
            content = new StringBuilder();
            if (this.file != null) {
                try (FileInputStream inputStream = new FileInputStream(this.file);){
                    this.read(inputStream, this.charsetName, content);
                    break block10;
                }
                catch (FileNotFoundException e) {
                    throw new ApplicationException(e.getMessage() + " - " + this.file.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
            }
            if (this.inputStream != null) {
                this.read(this.inputStream, this.charsetName, content);
            }
        }
        return content;
    }

    private void read(InputStream inputStream, String charsetName, StringBuilder content) throws ApplicationException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charsetName);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            String lineSeparator = System.getProperty("line.separator", "\r\n");
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append(lineSeparator);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public String getFilePath() {
        return this.file.getPath();
    }
}

