/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.util.TextFileLoader;

public class URLResourceLoader
extends TextFileLoader {
    private static final Logger logger = Logger.getLogger(URLResourceLoader.class.getName());
    private HttpURLConnection connection;

    public URLResourceLoader(URL url) throws ApplicationException {
        this.connect(url);
    }

    private void connect(URL url) throws ApplicationException {
        try {
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:80.0) Gecko/20100101 Firefox/80.0");
            String charsetName = this.connection.getContentEncoding();
            if (charsetName != null) {
                this.setCharset(charsetName);
            } else {
                charsetName = this.connection.getContentType();
            }
            if (charsetName != null && charsetName.indexOf(61) != -1) {
                this.setCharset(charsetName.split("=")[1]);
            }
            this.setInputStream(this.connection.getInputStream());
        }
        catch (IOException e) {
            throw new ApplicationException(e.toString(), e);
        }
    }

    public URLResourceLoader(URL url, boolean autoconnect) {
        while (autoconnect) {
            try {
                this.connect(url);
                autoconnect = false;
            }
            catch (ApplicationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public StringBuilder getContent() throws ApplicationException {
        StringBuilder buffer;
        try {
            buffer = super.getContent();
        }
        finally {
            this.disconnection();
        }
        return buffer;
    }

    public void disconnection() {
        this.connection.disconnect();
    }
}

