/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer.http;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.tinystruct.ApplicationException;
import org.tinystruct.transfer.http.AbstractReadableByteChannelWrapper;

public class ReadableByteChannelWrapper
extends AbstractReadableByteChannelWrapper {
    public ReadableByteChannelWrapper(ReadableByteChannel newChannel, int expected) {
        super(newChannel);
        this.setExpected(expected);
    }

    public ReadableByteChannelWrapper(URL uri) throws Exception {
        super(Channels.newChannel(uri.openStream()));
        this.setExpected(this.length(uri));
    }

    private int length(URL url) throws ApplicationException {
        int length;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            length = connection.getContentLength();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        return length;
    }

    @Override
    public void progress(double progress) {
        if (this.getExpected() != -1) {
            System.out.print("\r" + String.format("%d bytes received, %.02f%%", this.getReceived(), progress));
        } else {
            System.out.print("\r" + String.format("%d bytes received", this.getReceived()));
        }
    }
}

