/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer.http.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public class ContentDisposition {
    public static final String LINE = "\r\n";
    private final String name;
    private final String fileName;
    private final String contentType;
    private final byte[] data;

    public ContentDisposition(String name, String fileName, String contentType, byte[] data) {
        this.name = name;
        this.fileName = fileName;
        this.contentType = contentType;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getTransferBytes() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("Content-Disposition: form-data; name=\"").append(this.name).append("\"");
        if (this.fileName != null) {
            builder.append("; filename=\"").append(this.fileName).append("\"");
        }
        builder.append(LINE);
        if (this.fileName != null) {
            builder.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(this.fileName)).append(";").append(LINE);
            builder.append("Content-Transfer-Encoding: binary").append(LINE);
        } else {
            builder.append("Content-Type: text/plain; charset=utf-8").append(LINE);
        }
        builder.append(LINE);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        outputStream.write(this.data);
        outputStream.write(LINE.getBytes(StandardCharsets.UTF_8));
        return outputStream.toByteArray();
    }
}

