/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.valve.DistributedLock;

public class DistributedHashMap<T>
extends ConcurrentHashMap<String, Queue<T>> {
    private static final long serialVersionUID = 2329878484809829362L;
    private static final Logger logger = Logger.getLogger(DistributedHashMap.class.getName());
    private static final int FIXED_LOCK_DATA_SIZE = 44;
    private static final int HEADER_SIZE = 8;
    private static final int VERSION = 1;
    private RandomAccessFile data;
    private final FileChannel channel;
    private final DistributedLock lock = new DistributedLock();
    private final String dataFilePath = "." + this.lock.id() + ".data";
    private volatile int size;

    public DistributedHashMap() throws IOException {
        this.data = new RandomAccessFile(this.dataFilePath, "rw");
        this.channel = this.data.getChannel();
        if (this.data.length() == 0L) {
            this.initializeNewFile();
        } else {
            this.loadExistingData();
        }
    }

    private void initializeNewFile() throws IOException {
        ByteBuffer header = ByteBuffer.allocate(8);
        header.putInt(0);
        header.putInt(1);
        header.flip();
        this.channel.write(header, 0L);
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExistingData() throws IOException {
        try {
            this.lock.lock();
            ByteBuffer header = ByteBuffer.allocate(8);
            this.channel.read(header, 0L);
            header.flip();
            this.size = header.getInt();
            int version = header.getInt();
            if (version != 1) {
                throw new IOException("Incompatible data file version");
            }
            long position = 8L;
            for (int i = 0; i < this.size; ++i) {
                ByteBuffer entryHeader = ByteBuffer.allocate(8);
                this.channel.read(entryHeader, position);
                entryHeader.flip();
                int keyLength = entryHeader.getInt();
                int valueLength = entryHeader.getInt();
                ByteBuffer keyBuffer = ByteBuffer.allocate(keyLength);
                this.channel.read(keyBuffer, position + 8L);
                String key = new String(keyBuffer.array());
                ByteBuffer valueBuffer = ByteBuffer.allocate(valueLength);
                this.channel.read(valueBuffer, position + 8L + (long)keyLength);
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(valueBuffer.array()));){
                    Queue value = (Queue)ois.readObject();
                    super.put(key, value);
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.SEVERE, "Failed to deserialize value", e);
                }
                position += (long)(8 + keyLength + valueLength);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Queue<T> put(String key, Queue<T> value) {
        try {
            this.lock.tryLock(5L, TimeUnit.SECONDS);
            Queue<T> previous = super.put(key, value);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                byte[] serializedValue = baos.toByteArray();
                byte[] keyBytes = key.getBytes();
                long position = this.calculatePositionForNewEntry();
                ByteBuffer entryHeader = ByteBuffer.allocate(8);
                entryHeader.putInt(keyBytes.length);
                entryHeader.putInt(serializedValue.length);
                entryHeader.flip();
                this.channel.write(entryHeader, position);
                this.channel.write(ByteBuffer.wrap(keyBytes), position + 8L);
                this.channel.write(ByteBuffer.wrap(serializedValue), position + 8L + (long)keyBytes.length);
                ByteBuffer header = ByteBuffer.allocate(4);
                header.putInt(++this.size);
                header.flip();
                this.channel.write(header, 0L);
                Queue<T> queue = previous;
                return queue;
            }
            catch (IOException e) {
                try {
                    logger.log(Level.SEVERE, "Failed to write to data file", e);
                    throw new RuntimeException("Failed to persist data", e);
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Failed to acquire lock", e2);
                    throw new RuntimeException("Failed to acquire lock", e2);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private long calculatePositionForNewEntry() throws IOException {
        long position = 8L;
        for (int i = 0; i < this.size; ++i) {
            ByteBuffer entryHeader = ByteBuffer.allocate(8);
            this.channel.read(entryHeader, position);
            entryHeader.flip();
            int keyLength = entryHeader.getInt();
            int valueLength = entryHeader.getInt();
            position += (long)(8 + keyLength + valueLength);
        }
        return position;
    }

    @Override
    public Queue<T> remove(Object key) {
        try {
            this.lock.tryLock(5L, TimeUnit.SECONDS);
            Queue removed = (Queue)super.remove(key);
            if (removed != null) {
                this.rewriteFile();
            }
            Queue queue = removed;
            return queue;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to acquire lock", e);
            throw new RuntimeException("Failed to acquire lock", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rewriteFile() throws IOException {
        File tempFile = new File(this.dataFilePath + ".tmp");
        try (RandomAccessFile tempRaf = new RandomAccessFile(tempFile, "rw");
             FileChannel tempChannel = tempRaf.getChannel();){
            ByteBuffer header = ByteBuffer.allocate(8);
            header.putInt(this.size - 1);
            header.putInt(1);
            header.flip();
            tempChannel.write(header, 0L);
            long position = 8L;
            for (Map.Entry entry : this.entrySet()) {
                byte[] keyBytes = ((String)entry.getKey()).getBytes();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(entry.getValue());
                byte[] valueBytes = baos.toByteArray();
                ByteBuffer entryHeader = ByteBuffer.allocate(8);
                entryHeader.putInt(keyBytes.length);
                entryHeader.putInt(valueBytes.length);
                entryHeader.flip();
                tempChannel.write(entryHeader, position);
                tempChannel.write(ByteBuffer.wrap(keyBytes), position + 8L);
                tempChannel.write(ByteBuffer.wrap(valueBytes), position + 8L + (long)keyBytes.length);
                position += (long)(8 + keyBytes.length + valueBytes.length);
            }
        }
        this.data.close();
        File oldFile = new File(this.dataFilePath);
        if (!tempFile.renameTo(oldFile)) {
            throw new IOException("Failed to replace data file");
        }
        this.data = new RandomAccessFile(this.dataFilePath, "rw");
        --this.size;
    }

    @Override
    public void clear() {
        try {
            this.lock.tryLock(5L, TimeUnit.SECONDS);
            super.clear();
            this.channel.truncate(0L);
            this.initializeNewFile();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to acquire lock", e);
            throw new RuntimeException("Failed to acquire lock", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.data != null) {
                this.data.close();
            }
            new File(this.dataFilePath).delete();
        }
        finally {
            super.finalize();
        }
    }
}

