/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.valve.Lock;
import org.tinystruct.valve.LockKey;
import org.tinystruct.valve.Watcher;

public class DistributedLock
implements Lock {
    private final String id;
    private final Watcher watcher;
    private volatile Thread owner;
    private static final Logger logger = Logger.getLogger(DistributedLock.class.getName());

    public DistributedLock() {
        this.id = UUID.randomUUID().toString();
        this.watcher = Watcher.getInstance();
        this.watcher.addListener(new Watcher.LockEventListener(this));
    }

    public DistributedLock(byte[] idb) {
        this.id = new LockKey(idb).value();
        this.watcher = Watcher.getInstance();
        this.watcher.addListener(new Watcher.LockEventListener(this));
    }

    public DistributedLock(String lockId) {
        this(lockId.getBytes());
    }

    @Override
    public void lock() {
        Thread current = Thread.currentThread();
        if (current == this.owner) {
            return;
        }
        try {
            while (!this.tryLock(1000L, TimeUnit.MILLISECONDS)) {
                logger.log(Level.FINE, "Waiting for lock to be released...");
            }
        }
        catch (ApplicationException e) {
            throw new ApplicationRuntimeException("Failed to acquire lock", e);
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, TimeUnit.SECONDS);
        }
        catch (ApplicationException e) {
            logger.severe("Error while attempting to lock: " + e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws ApplicationException {
        Thread current = Thread.currentThread();
        if (current == this.owner) {
            return true;
        }
        DistributedLock distributedLock = this;
        synchronized (distributedLock) {
            if (this.watcher.watch(this)) {
                try {
                    if (timeout > 0L) {
                        this.watcher.waitFor(this.id, timeout, unit);
                    } else {
                        this.watcher.waitFor(this.id);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.severe("Error while waiting for lock: " + e.getMessage());
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
            }
            this.watcher.register(this);
            this.owner = current;
        }
        return true;
    }

    @Override
    public void unlock() {
        Thread current = Thread.currentThread();
        if (this.owner == null) {
            return;
        }
        if (current != this.owner) {
            throw new IllegalMonitorStateException("Thread " + current.getName() + " attempting to unlock while not holding the lock");
        }
        try {
            this.watcher.unregister(this);
            this.owner = null;
        }
        catch (ApplicationException e) {
            logger.severe("Error while unlocking: " + String.valueOf(e));
            throw new ApplicationRuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DistributedLock other = (DistributedLock)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

