/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.valve.DistributedLock;
import org.tinystruct.valve.Lock;

public final class Watcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(Watcher.class.getName());
    private static final byte[] EMPTY_BYTES = new byte[36];
    private static final int FIXED_LOCK_DATA_SIZE = 44;
    private static final String LOCK = ".lock";
    private final ConcurrentHashMap<String, EventListener> listeners = new ConcurrentHashMap(8);
    private final ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap(16);
    private int[] interspace;
    private volatile boolean started = false;
    private volatile boolean stopped = false;

    private Watcher() {
        try (RandomAccessFile lockFile = new RandomAccessFile(LOCK, "r");){
            this.interspace = new int[(int)(lockFile.length() / 44L + 1L)];
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    public static Watcher getInstance() {
        return SingletonHolder.manager;
    }

    public void waitFor(String lockId) throws InterruptedException {
        this.listeners.get(lockId).waitFor();
    }

    public void waitFor(String lockId, long timeout, TimeUnit unit) throws InterruptedException {
        this.listeners.get(lockId).waitFor(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.started = true;
        while (!this.stopped) {
            Class<Watcher> clazz = Watcher.class;
            // MONITORENTER : org.tinystruct.valve.Watcher.class
            try {
                Watcher.class.wait();
            }
            catch (InterruptedException e) {
                logger.severe(e.getMessage());
            }
            this.synchronizeLocks();
            // MONITOREXIT : clazz
        }
    }

    private void synchronizeLocks() {
        try (RandomAccessFile lockFile = new RandomAccessFile(LOCK, "rwd");){
            if (lockFile.length() >= 44L) {
                int size = (int)lockFile.length() / 44;
                FileLock fileLock = lockFile.getChannel().tryLock();
                if (fileLock != null) {
                    this.updateLocksFromFile(lockFile, size);
                    fileLock.release();
                }
            } else {
                lockFile.setLength(0L);
            }
            Watcher.class.notifyAll();
        }
        catch (IOException e) {
            this.stop();
            logger.severe(e.getMessage());
        }
    }

    private void updateLocksFromFile(RandomAccessFile lockFile, int size) throws IOException {
        if (size > 0) {
            lockFile.seek(0L);
            for (int i = 0; i < size && lockFile.length() > 0L; ++i) {
                String lockId;
                boolean condition;
                byte[] id = EMPTY_BYTES;
                boolean bl = condition = lockFile.read(id) != -1 && lockFile.readLong() == 1L;
                if (!condition || this.locks.containsKey(lockId = new String(id, StandardCharsets.UTF_8))) continue;
                this.locks.putIfAbsent(lockId, new DistributedLock(id));
                EventListener listener = this.listeners.get(lockId);
                if (listener == null) continue;
                listener.onCreate(lockId);
            }
        }
    }

    public void addListener(EventListener listener) {
        this.listeners.put(listener.id(), listener);
    }

    private void start() {
        Thread monitor = new Thread(this);
        monitor.setDaemon(true);
        monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watch(Lock lock) throws ApplicationException {
        Class<Lock> clazz = Lock.class;
        synchronized (Lock.class) {
            if (!this.started) {
                this.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.locks.containsKey(lock.id());
        }
    }

    public void register(Lock lock) throws ApplicationException {
        this.register(lock, 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Lock lock, long expiration, TimeUnit tu) throws ApplicationException {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            String lockId = lock.id();
            if (!this.locks.containsKey(lockId)) {
                try (RandomAccessFile lockFile = new RandomAccessFile(LOCK, "rw");
                     FileLock fileLock = lockFile.getChannel().tryLock();){
                    long length = lockFile.length();
                    if (null != fileLock) {
                        int size;
                        byte[] empty = EMPTY_BYTES;
                        if (length >= 44L) {
                            size = (int)(length / 44L);
                            this.interspace = new int[size];
                        } else {
                            size = 0;
                        }
                        boolean required = true;
                        boolean registered = false;
                        if (size > 0) {
                            int i;
                            for (i = 0; i < size; ++i) {
                                int position = i * 44;
                                lockFile.seek(position);
                                if (lockFile.read(empty) == -1) continue;
                                if (Arrays.equals(lockId.getBytes(), empty)) {
                                    if (lockFile.readLong() == 0L) {
                                        lockFile.seek(position + EMPTY_BYTES.length);
                                        lockFile.writeLong(1L);
                                    }
                                    this.interspace[i] = 0;
                                    required = false;
                                    registered = true;
                                    break;
                                }
                                if (lockFile.readLong() != 0L) continue;
                                this.interspace[i] = 1;
                                required = false;
                            }
                            if (!registered) {
                                for (i = 0; i < size; ++i) {
                                    if (this.interspace[i] != 1) continue;
                                    lockFile.seek((long)i * 44L);
                                    lockFile.writeBytes(lockId);
                                    lockFile.writeLong(1L);
                                    this.interspace[i] = 0;
                                    required = false;
                                    break;
                                }
                            }
                        }
                        if (required) {
                            lockFile.seek((long)size * 44L);
                            lockFile.writeBytes(lockId);
                            lockFile.writeLong(1L);
                        }
                        this.locks.putIfAbsent(lockId, lock);
                        if (this.listeners.get(lockId) != null) {
                            this.listeners.get(lockId).onCreate(lockId);
                        }
                        fileLock.release();
                        Watcher.class.notify();
                    }
                }
                catch (IOException e) {
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Lock lock) throws ApplicationException {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            String lockId = lock.id();
            if (this.locks.containsKey(lockId)) {
                try (RandomAccessFile lockFile = new RandomAccessFile(LOCK, "rw");){
                    long length = lockFile.length();
                    if (length < 44L) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    try (FileLock fileLock = lockFile.getChannel().tryLock();){
                        if (null != fileLock) {
                            byte[] empty = EMPTY_BYTES;
                            int size = (int)(length / 44L);
                            this.interspace = new int[size];
                            int availableLockSize = size;
                            for (int i = 0; i < size; ++i) {
                                boolean condition;
                                int position = i * 44;
                                lockFile.seek(position);
                                boolean bl = condition = lockFile.read(empty) != -1 && Arrays.equals(lockId.getBytes(), empty);
                                if (!condition) continue;
                                lockFile.seek(position + EMPTY_BYTES.length);
                                lockFile.writeLong(0L);
                                this.locks.remove(lockId);
                                if (this.listeners.get(lockId) != null) {
                                    this.listeners.get(lockId).onDelete(lockId);
                                }
                                if (--availableLockSize != 0) break;
                                if (!this.locks.isEmpty()) {
                                    this.locks.clear();
                                }
                                lockFile.setLength(0L);
                                break;
                            }
                            fileLock.release();
                            Watcher.class.notify();
                        } else {
                            this.unregister(lock);
                        }
                    }
                }
                catch (IOException e) {
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock acquire() {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            Lock lock;
            if (null != this.locks && !this.locks.isEmpty() && null != (lock = this.locks.values().toArray(new Lock[0])[0])) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return lock;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DistributedLock();
        }
    }

    public void stop() {
        this.stopped = this.locks.isEmpty();
    }

    private static final class SingletonHolder {
        static final Watcher manager = new Watcher();

        private SingletonHolder() {
        }
    }

    public static interface EventListener {
        public void onCreate(String var1);

        public void onUpdate();

        public void onDelete(String var1);

        public String id();

        public void waitFor() throws InterruptedException;

        public boolean waitFor(long var1, TimeUnit var3) throws InterruptedException;
    }

    static class LockEventListener
    implements EventListener {
        private static final Logger logger = Logger.getLogger(LockEventListener.class.getName());
        private final Lock lock;
        private CountDownLatch latch;

        LockEventListener(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void onCreate(String lockId) {
            if (lockId.equalsIgnoreCase(this.lock.id())) {
                this.latch = new CountDownLatch(1);
                logger.log(Level.FINE, "Created " + lockId);
            }
        }

        @Override
        public void onUpdate() {
        }

        @Override
        public void onDelete(String lockId) {
            if (lockId.equalsIgnoreCase(this.lock.id())) {
                logger.log(Level.FINE, "Deleted " + lockId);
                this.latch.countDown();
            }
        }

        @Override
        public String id() {
            return this.lock.id();
        }

        @Override
        public void waitFor() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

