/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.utplsql.api.Version;
import org.utplsql.api.db.DatabaseInformation;
import org.utplsql.api.exception.UtPLSQLNotInstalledException;

public class DefaultDatabaseInformation
implements DatabaseInformation {
    @Override
    public Version getUtPlsqlFrameworkVersion(Connection conn) throws SQLException {
        Version result = Version.create("");
        try (PreparedStatement stmt = conn.prepareStatement("select ut_runner.version() from dual");){
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                result = Version.create(rs.getString(1));
            }
            rs.close();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 904) {
                throw new UtPLSQLNotInstalledException(e);
            }
            throw e;
        }
        return result;
    }

    @Override
    public String getOracleVersion(Connection conn) throws SQLException {
        String result = null;
        try (PreparedStatement stmt = conn.prepareStatement("select version from product_component_version where product like 'Oracle Database%'");){
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        return result;
    }

    @Override
    public String getCurrentSchema(Connection conn) throws SQLException {
        try (CallableStatement callableStatement = conn.prepareCall("BEGIN ? := sys_context('userenv', 'current_schema'); END;");){
            callableStatement.registerOutParameter(1, 12);
            callableStatement.executeUpdate();
            String string = callableStatement.getString(1);
            return string;
        }
    }

    @Override
    public int frameworkCompatibilityCheck(Connection conn, String requested, @Nullable String current) throws SQLException {
        try (CallableStatement callableStatement = conn.prepareCall("BEGIN ? := ut_runner.version_compatibility_check(?, ?); END;");){
            callableStatement.registerOutParameter(1, 5);
            callableStatement.setString(2, requested);
            if (current == null) {
                callableStatement.setNull(3, 12);
            } else {
                callableStatement.setString(3, current);
            }
            callableStatement.executeUpdate();
            int n = callableStatement.getInt(1);
            return n;
        }
    }
}

