/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.exception;

import java.sql.SQLException;
import org.utplsql.api.Version;

public class DatabaseNotCompatibleException
extends SQLException {
    private final Version clientVersion;
    private final Version databaseVersion;

    public DatabaseNotCompatibleException(String message, Version clientVersion, Version databaseVersion, Throwable cause) {
        super(message, cause);
        this.clientVersion = clientVersion;
        this.databaseVersion = databaseVersion;
    }

    public DatabaseNotCompatibleException(Version clientVersion, Version databaseVersion, Throwable cause) {
        this("utPLSQL API (" + clientVersion + ") not compatible with database (" + databaseVersion + ")", clientVersion, databaseVersion, cause);
    }

    public DatabaseNotCompatibleException(Version clientVersion, Version databaseVersion) {
        this(clientVersion, databaseVersion, null);
    }

    public DatabaseNotCompatibleException(Version databaseVersion, Throwable cause) {
        this(Version.create("3"), databaseVersion, cause);
    }

    public DatabaseNotCompatibleException(Version databaseVersion) {
        this(Version.create("3"), databaseVersion, null);
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public Version getDatabaseVersion() {
        return this.databaseVersion;
    }
}

