/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter;

import org.utplsql.api.Version;
import org.utplsql.api.exception.InvalidVersionException;

public enum CoreReporters {
    UT_COVERAGE_COBERTURA_REPORTER(Version.V3_1_0, null),
    UT_COVERAGE_HTML_REPORTER(Version.V3_0_0, null),
    UT_COVERAGE_SONAR_REPORTER(Version.V3_0_0, null),
    UT_COVERALLS_REPORTER(Version.V3_0_0, null),
    UT_DEBUG_REPORTER(Version.V3_1_4, null),
    UT_DOCUMENTATION_REPORTER(Version.V3_0_0, null),
    UT_JUNIT_REPORTER(Version.V3_1_0, null),
    UT_REALTIME_REPORTER(Version.V3_1_4, null),
    UT_SONAR_TEST_REPORTER(Version.V3_0_0, null),
    UT_TEAMCITY_REPORTER(Version.V3_0_0, null),
    UT_TFS_JUNIT_REPORTER(Version.V3_1_0, null),
    UT_XUNIT_REPORTER(Version.V3_0_0, null);

    private final Version since;
    private final Version until;

    private CoreReporters(Version since, Version until) {
        this.since = since;
        this.until = until;
    }

    public Version getSince() {
        return this.since;
    }

    public Version getUntil() {
        return this.until;
    }

    public boolean isAvailableFor(Version databaseVersion) {
        try {
            if ((this.since == null || databaseVersion.isGreaterOrEqualThan(this.since)) && (this.until == null || databaseVersion.isLessOrEqualThan(this.until))) {
                return true;
            }
        }
        catch (InvalidVersionException invalidVersionException) {
            // empty catch block
        }
        return false;
    }
}

