/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.reporter.ReporterFactory;

public abstract class Reporter
implements ORAData {
    private static final Logger logger = LoggerFactory.getLogger(Reporter.class);
    protected OutputBuffer outputBuffer;
    private String selfType;
    private String id;
    private Object[] attributes;
    private boolean init = false;

    public Reporter(String typeName, Object[] attributes) {
        this.setTypeName(typeName);
        this.setAttributes(attributes);
    }

    public Reporter init(Connection con, CompatibilityProxy compatibilityProxy, ReporterFactory reporterFactory) throws SQLException {
        if (compatibilityProxy == null) {
            compatibilityProxy = new CompatibilityProxy(con);
        }
        if (reporterFactory == null) {
            reporterFactory = new ReporterFactory();
        }
        OracleConnection oraConn = con.unwrap(OracleConnection.class);
        this.initDbReporter(oraConn, reporterFactory);
        this.init = true;
        this.initOutputBuffer(oraConn, compatibilityProxy);
        return this;
    }

    public Reporter init(Connection con) throws SQLException {
        return this.init(con, null, null);
    }

    protected abstract void initOutputBuffer(OracleConnection var1, CompatibilityProxy var2) throws SQLException;

    private void initDbReporter(OracleConnection oraConn, ReporterFactory reporterFactory) throws SQLException {
        OracleCallableStatement callableStatement = (OracleCallableStatement)oraConn.prepareCall("{? = call " + this.selfType + "()}");
        callableStatement.registerOutParameter(1, 2002, "UT_REPORTER_BASE");
        callableStatement.execute();
        Reporter obj = (Reporter)callableStatement.getORAData(1, (ORADataFactory)reporterFactory);
        this.setAttributes(obj.getAttributes());
        logger.debug("Database-reporter initialized, Type: {}, ID: {}", (Object)this.selfType, (Object)this.id);
    }

    protected Object[] getAttributes() {
        return this.attributes;
    }

    protected void setAttributes(Object[] attributes) {
        if (attributes != null) {
            this.id = DatatypeConverter.printHexBinary((byte[])attributes[1]);
        }
        this.attributes = attributes;
    }

    public boolean isInit() {
        return this.init;
    }

    public String getTypeName() {
        return this.selfType;
    }

    protected void setTypeName(String typeName) {
        this.selfType = typeName.replaceAll("[^0-9a-zA-Z_\\.]", "");
    }

    public String getId() {
        return this.id;
    }

    public Datum toDatum(Connection c) throws SQLException {
        return (Datum)c.createStruct(this.getTypeName(), this.getAttributes());
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    private static class DatatypeConverter {
        private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

        private DatatypeConverter() {
        }

        static String printHexBinary(byte[] data) {
            StringBuilder r = new StringBuilder(data.length * 2);
            for (byte b : data) {
                r.append(hexCode[b >> 4 & 0xF]);
                r.append(hexCode[b & 0xF]);
            }
            return r.toString();
        }
    }
}

