/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.testRunner;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import org.utplsql.api.TestRunnerOptions;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.OptionalFeatures;
import org.utplsql.api.db.DynamicParameterList;
import org.utplsql.api.testRunner.FileMapper;
import org.utplsql.api.testRunner.TestRunnerStatement;

public class DynamicTestRunnerStatement
implements TestRunnerStatement {
    private CallableStatement stmt;
    private final OracleConnection oracleConnection;
    private final Version utPlSQlVersion;
    private final TestRunnerOptions options;
    private final DynamicParameterList dynamicParameterList;

    private DynamicTestRunnerStatement(Version utPlSQlVersion, OracleConnection connection, TestRunnerOptions options, CallableStatement statement) throws SQLException {
        this.utPlSQlVersion = utPlSQlVersion;
        this.oracleConnection = connection;
        this.options = options;
        this.stmt = statement;
        this.dynamicParameterList = this.initParameterList();
        this.prepareStatement();
    }

    private DynamicParameterList initParameterList() throws SQLException {
        Object[] sourceMappings = this.options.sourceMappingOptions != null ? FileMapper.buildFileMappingList((Connection)this.oracleConnection, this.options.sourceMappingOptions).toArray() : null;
        Object[] testMappings = this.options.testMappingOptions != null ? FileMapper.buildFileMappingList((Connection)this.oracleConnection, this.options.testMappingOptions).toArray() : null;
        DynamicParameterList.DynamicParameterListBuilder builder = DynamicParameterList.builder().addIfNotEmpty("a_paths", this.options.pathList.toArray(), "UT_VARCHAR2_LIST", this.oracleConnection).addIfNotEmpty("a_reporters", this.options.reporterList.toArray(), "UT_REPORTERS", this.oracleConnection).addIfNotEmpty("a_color_console", this.options.colorConsole).addIfNotEmpty("a_coverage_schemes", this.options.coverageSchemes.toArray(), "UT_VARCHAR2_LIST", this.oracleConnection).addIfNotEmpty("a_source_file_mappings", sourceMappings, "UT_FILE_MAPPINGS", this.oracleConnection).addIfNotEmpty("a_test_file_mappings", testMappings, "UT_FILE_MAPPINGS", this.oracleConnection).addIfNotEmpty("a_include_objects", this.options.includeObjects.toArray(), "UT_VARCHAR2_LIST", this.oracleConnection).addIfNotEmpty("a_exclude_objects", this.options.excludeObjects.toArray(), "UT_VARCHAR2_LIST", this.oracleConnection);
        if (OptionalFeatures.FAIL_ON_ERROR.isAvailableFor(this.utPlSQlVersion)) {
            builder.addIfNotEmpty("a_fail_on_errors", this.options.failOnErrors);
        }
        if (OptionalFeatures.CLIENT_CHARACTER_SET.isAvailableFor(this.utPlSQlVersion)) {
            builder.addIfNotEmpty("a_client_character_set", this.options.clientCharacterSet);
        }
        if (OptionalFeatures.RANDOM_EXECUTION_ORDER.isAvailableFor(this.utPlSQlVersion)) {
            builder.addIfNotEmpty("a_random_test_order", this.options.randomTestOrder).addIfNotEmpty("a_random_test_order_seed", this.options.randomTestOrderSeed);
        }
        if (OptionalFeatures.TAGS.isAvailableFor(this.utPlSQlVersion)) {
            builder.addIfNotEmpty("a_tags", this.options.getTagsAsString());
        }
        if (OptionalFeatures.EXPR.isAvailableFor(this.utPlSQlVersion)) {
            builder.addIfNotEmpty("a_include_schema_expr", this.options.includeSchemaExpr).addIfNotEmpty("a_include_object_expr", this.options.includeObjectExpr).addIfNotEmpty("a_exclude_schema_expr", this.options.excludeSchemaExpr).addIfNotEmpty("a_exclude_object_expr", this.options.excludeObjectExpr);
        }
        return builder.build();
    }

    private void prepareStatement() throws SQLException {
        if (this.stmt == null) {
            String sql = "BEGIN ut_runner.run(" + this.dynamicParameterList.getSql() + ");END;";
            this.stmt = this.oracleConnection.prepareCall(sql);
        }
        this.dynamicParameterList.setParamsStartWithIndex(this.stmt, 1);
    }

    @Override
    public void execute() throws SQLException {
        this.stmt.execute();
    }

    @Override
    public String getSql() {
        return this.dynamicParameterList.getSql();
    }

    @Override
    public void close() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public static DynamicTestRunnerStatement forVersion(Version version, Connection connection, TestRunnerOptions options, CallableStatement statement) throws SQLException {
        OracleConnection oraConn = connection.unwrap(OracleConnection.class);
        return new DynamicTestRunnerStatement(version, oraConn, options, statement);
    }
}

