/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.formatters;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.springframework.format.Formatter;
import org.springframework.util.StringUtils;
import pl.fhframework.format.FhFormatter;

@FhFormatter(value="currencyFormatter2")
public class CurrencyFormatter2
implements Formatter<BigDecimal> {
    private static final ThreadLocal<DecimalFormat> customFormat = ThreadLocal.withInitial(() -> new DecimalFormat(){
        {
            DecimalFormatSymbols pSymbols = this.getDecimalFormatSymbols();
            pSymbols.setDecimalSeparator(',');
            pSymbols.setGroupingSeparator(' ');
            this.setDecimalFormatSymbols(pSymbols);
            this.setGroupingUsed(true);
            this.setParseBigDecimal(true);
            this.setMinimumFractionDigits(2);
            this.setMaximumFractionDigits(2);
            this.setRoundingMode(RoundingMode.HALF_UP);
        }
    });

    public BigDecimal parse(String stringValue, Locale locale) throws ParseException {
        if (!StringUtils.isEmpty((Object)stringValue)) {
            stringValue = stringValue.replace('.', ',');
        }
        return (BigDecimal)customFormat.get().parse(stringValue);
    }

    public String print(BigDecimal value, Locale locale) {
        String pRetVal = "";
        if (value != null) {
            pRetVal = customFormat.get().format(value);
        }
        return pRetVal;
    }
}

