/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import pl.fhframework.BindingResult;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.attributes.AbstractIntegerAttribute;
import pl.fhframework.model.forms.attributes.BoundableAttribute;

public abstract class AbstractBoundableIntegerAttribute
extends AbstractIntegerAttribute
implements BoundableAttribute {
    @JsonIgnore
    private ModelBinding modelBinding;

    public AbstractBoundableIntegerAttribute(Form form, Component component, ModelBinding modelBinding) {
        super(form, component, modelBinding);
        this.modelBinding = modelBinding;
    }

    @Override
    public ElementChanges updateView(Component component, ElementChanges elementChanges) {
        Integer newValue;
        BindingResult bindingResult;
        if (this.modelBinding != null && (bindingResult = this.modelBinding.getBindingResult()) != null && !Objects.equals(newValue = (Integer)component.convertValue(bindingResult.getValue(), Integer.class), this.value)) {
            this.value = newValue;
            elementChanges.addChange(this.getXmlValue(), (Object)this.value);
        }
        return elementChanges;
    }

    @Override
    public void updateModel(Component component, ValueChange valueChange) {
        String newValue = valueChange.getStringAttribute(this.getXmlValue());
        if (newValue != null && !Objects.equals(component.convertValue((Object)newValue, Integer.class), this.value)) {
            this.updateBindingForValue(newValue, this.modelBinding, this.value);
        }
    }

    @Override
    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    @Override
    @JsonIgnore
    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }
}

