/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.messages;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.UserSession;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.AdHocActionBinding;
import pl.fhframework.binding.AdHocModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.messages.Action;
import pl.fhframework.core.messages.IMessages;
import pl.fhframework.core.messages.MessagePopup;
import pl.fhframework.core.uc.IFormUseCaseContext;
import pl.fhframework.core.uc.UseCaseContainer;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.events.ViewEvent;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.forms.Button;
import pl.fhframework.model.forms.Canvas;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.Spacer;
import pl.fhframework.model.forms.attribute.FormType;
import pl.fhframework.model.forms.messages.ActionButton;

@org.springframework.stereotype.Component
public class Messages
implements IMessages {
    private static final String THIS_FOR_ACTION_NAME = "(EVENT)";
    private static String newline = System.getProperty("line.separator");
    private static final AtomicInteger ACTION_SEQ = new AtomicInteger(1);
    private static MessageService messageService;
    @Autowired
    private MessageService messageServiceWired;

    @PostConstruct
    public void init() {
        messageService = this.messageServiceWired;
    }

    public static MessagePopup showInfoMessage(UserSession session, String message) {
        return Messages.showInfoMessage(session, message, false);
    }

    public static MessagePopup showInfoMessageNoOverflow(UserSession session, String message) {
        return Messages.showInfoMessage(session, message, true);
    }

    protected static MessagePopup showInfoMessage(UserSession session, String message, boolean noOverflow) {
        String messageTitle = messageService.getAllBundles().getMessage("fh.core.dialog.info.title", "Information");
        return Messages.showMessage(session, messageTitle, message, Severity.INFO, noOverflow);
    }

    public static MessagePopup showActionMessage(UserSession session, String title, TextMessage textMessage, Severity severity, ActionButton ... actions) {
        return Messages.showActionMessage(session, title, textMessage.toMessageString(), severity, actions);
    }

    public static MessagePopup showActionMessage(UserSession session, String title, String message, Severity severity, ActionButton ... actions) {
        MessagePopup dialog = Messages.builder(session).withDialogTitle(title).withMessage(message).withButtonActions(Arrays.asList(actions)).withSeverityLevel(severity).build();
        dialog.showDialog();
        return dialog;
    }

    public static MessagePopup showMessage(UserSession session, String dialogTitle, String message, Severity severity) {
        return Messages.showMessage(session, dialogTitle, message, severity, false);
    }

    public static MessagePopup showMessageNoOverflow(UserSession session, String dialogTitle, String message, Severity severity) {
        return Messages.showMessage(session, dialogTitle, message, severity, true);
    }

    protected static MessagePopup showMessage(UserSession session, String dialogTitle, String message, Severity severity, boolean noOverflow) {
        MessagePopup dialog = Messages.builder(session).withDialogTitle(dialogTitle).withMessage(message).withSeverityLevel(severity).withFormType(noOverflow ? FormType.MODAL : FormType.MODAL_OVERFLOW).build();
        UseCaseContainer.PopupMessageUseCaseContextMessage usecaseWrapper = (UseCaseContainer.PopupMessageUseCaseContextMessage)dialog.getAbstractUseCase();
        Button closeButton = new Button((Form)dialog);
        closeButton.setWidth("md-3");
        String actionName = Messages.nextActionName();
        String closeBtnLabel = messageService.getAllBundles().getMessage("fh.core.dialog.button.close", "Close");
        closeButton.setLabelModelBinding((ModelBinding)closeButton.createAdHocModelBinding(closeBtnLabel));
        closeButton.setOnClick((ActionBinding)new AdHocActionBinding(actionName + THIS_FOR_ACTION_NAME, (Form)dialog, (Component)dialog));
        dialog.addSubcomponent((Component)closeButton);
        usecaseWrapper.setActionViewEvent(actionName, Messages::close);
        dialog.configure((IFormUseCaseContext)usecaseWrapper, null);
        usecaseWrapper.showForm((Form)dialog, false);
        return dialog;
    }

    public static MessagePopup showErrorMessage(UserSession session, String message, Throwable error) {
        return Messages.showErrorMessage(session, message, error, false);
    }

    public static MessagePopup showErrorMessageNoOverflow(UserSession session, String message, Throwable error) {
        return Messages.showErrorMessage(session, message, error, true);
    }

    protected static MessagePopup showErrorMessage(UserSession session, String message, Throwable error, boolean noOverflow) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.nullToEmpty((String)message)).append(newline);
        if (error != null) {
            sb.append(newline).append("[ ").append(error.getMessage()).append(" ]");
        }
        String errorTitle = messageService.getAllBundles().getMessage("fh.core.dialog.error.title", "Error");
        return Messages.showMessage(session, errorTitle, message, Severity.ERROR, noOverflow);
    }

    public MessagePopup showInfo(UserSession session, String message, Action action) {
        return this.showInfo(session, null, message, action);
    }

    public MessagePopup showInfo(UserSession session, String title, String message, Action action) {
        if (title == null) {
            title = messageService.getAllBundles().getMessage("fh.core.dialog.info.title", "Information");
        }
        return this.showDialog(session, title, message, Severity.INFO, action);
    }

    public MessagePopup showConfirmation(UserSession session, String message, Action action) {
        return this.showConfirmation(session, null, message, action);
    }

    public MessagePopup showConfirmation(UserSession session, String title, String message, Action action) {
        if (title == null) {
            title = messageService.getAllBundles().getMessage("fh.core.dialog.info.confirmation", "Confirmation");
        }
        Builder confirmDialogBuilder = Messages.builder(session).withDialogTitle(title).withSeverityLevel(Severity.INFO).withMessage(message).withButtonAction(ActionButton.get(messageService.getAllBundles().getMessage("fh.core.dialog.button.yes", "Yes"), viewEvent -> {
            Messages.close(viewEvent);
            action.doAction();
        })).withButtonAction(ActionButton.getClose(messageService.getAllBundles().getMessage("fh.core.dialog.button.no", "No")));
        MessagePopup confirmDialog = confirmDialogBuilder.build();
        confirmDialog.showDialog();
        return confirmDialog;
    }

    public MessagePopup showError(UserSession session, String message, Action action) {
        return this.showError(session, null, message, action);
    }

    public MessagePopup showError(UserSession session, String title, String message, Action action) {
        if (title == null) {
            title = messageService.getAllBundles().getMessage("fh.core.dialog.error.title", "Error");
        }
        return this.showDialog(session, title, message, Severity.ERROR, action);
    }

    private MessagePopup showDialog(UserSession session, String title, String message, Severity severity, Action action) {
        MessagePopup dialog = Messages.builder(session).withDialogTitle(title).withMessage(message).withSeverityLevel(severity).build();
        UseCaseContainer.PopupMessageUseCaseContextMessage usecaseWrapper = (UseCaseContainer.PopupMessageUseCaseContextMessage)dialog.getAbstractUseCase();
        Button closeButton = new Button((Form)dialog);
        closeButton.setWidth("md-3");
        String actionName = Messages.nextActionName();
        String closeBtnLabel = messageService.getAllBundles().getMessage("fh.core.dialog.button.close", "Close");
        closeButton.setLabelModelBinding((ModelBinding)closeButton.createAdHocModelBinding(closeBtnLabel));
        closeButton.setOnClick(() -> {
            session.getUseCaseContainer().getFormsContainer().closeForm((Form)dialog);
            if (action != null) {
                action.doAction();
            }
        });
        dialog.addSubcomponent((Component)closeButton);
        usecaseWrapper.setActionViewEvent(actionName, Messages::close);
        dialog.configure((IFormUseCaseContext)usecaseWrapper, null);
        usecaseWrapper.showForm((Form)dialog, false);
        return dialog;
    }

    public static void showMessage(Builder builder) {
        builder.build().showDialog();
    }

    public static void close(ViewEvent viewEvent) {
        ((UseCaseContainer.PopupMessageUseCaseContextMessage)viewEvent.getSourceForm().getAbstractUseCase()).close(viewEvent);
    }

    private static String nextActionName() {
        return "messageAction" + ACTION_SEQ.getAndIncrement();
    }

    public static Builder builder(UserSession userSession) {
        return new Builder(userSession);
    }

    public static class Builder {
        private Optional<String> messageTitle = Optional.empty();
        private Optional<String> dialogId = Optional.empty();
        private Optional<String> dialogTitle = Optional.empty();
        private Optional<String> messageData = Optional.empty();
        private Optional<Severity> severity = Optional.empty();
        private Optional<FormType> formType = Optional.empty();
        private List<ActionButton> actions = new LinkedList<ActionButton>();
        private UserSession session;
        private boolean bindableText = false;

        Builder(UserSession session) {
            this.session = session;
        }

        @Deprecated
        public Builder withMessageTitle(String messageTitle) {
            this.messageTitle = Optional.ofNullable(messageTitle);
            return this;
        }

        public Builder withDialogId(String dialogId) {
            this.dialogId = Optional.ofNullable(dialogId);
            return this;
        }

        public Builder withDialogTitle(String dialogTitle) {
            this.dialogTitle = Optional.ofNullable(dialogTitle);
            return this;
        }

        public Builder withMessage(String messageData) {
            this.messageData = Optional.ofNullable(messageData);
            return this;
        }

        public Builder withButtonAction(ActionButton action) {
            this.actions.add(action);
            return this;
        }

        public Builder withButtonActions(Collection<ActionButton> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder withSeverityLevel(Severity severityLevel) {
            this.severity = Optional.ofNullable(severityLevel);
            return this;
        }

        public Builder enableBindableText() {
            this.bindableText = true;
            return this;
        }

        public Builder withFormType(FormType formType) {
            this.formType = Optional.ofNullable(formType);
            return this;
        }

        public MessagePopup build() {
            MessagePopup dialog = this.createDialog(this.session, this.dialogId, this.dialogTitle, this.messageTitle, this.messageData, this.severity, this.formType);
            for (ActionButton actionButton : this.actions) {
                Button button = new Button((Form)dialog);
                button.setWidth("sm-4");
                String actionName = Messages.nextActionName();
                button.setLabelModelBinding(this.binding(actionButton.getButtonLabel(), (Component)button));
                if (actionButton.getButtonStyle() != null) {
                    button.setStyleModelBinding(this.binding(actionButton.getButtonStyle(), (Component)button));
                }
                button.setOnClick((ActionBinding)new AdHocActionBinding(actionName, (Form)dialog, (Component)dialog));
                dialog.addSubcomponent((Component)button);
                UseCaseContainer.PopupMessageUseCaseContextMessage useCaseWrapper = (UseCaseContainer.PopupMessageUseCaseContextMessage)dialog.getAbstractUseCase();
                if (actionButton.getAction() != null) {
                    useCaseWrapper.setAction(actionName, actionButton.getAction());
                }
                if (actionButton.getViewEventAction() == null) continue;
                useCaseWrapper.setActionViewEvent(actionName, actionButton.getViewEventAction());
                button.setOnClick((ActionBinding)new AdHocActionBinding(actionName + Messages.THIS_FOR_ACTION_NAME, (Form)dialog, (Component)dialog));
            }
            return dialog;
        }

        private MessagePopup createDialog(UserSession session, Optional<String> dialogId, Optional<String> dialogTitle, Optional<String> messageTitle, Optional<String> messageData, Optional<Severity> severity, Optional<FormType> formType) {
            UseCaseContainer useCaseContainer;
            MessagePopup dialog = new MessagePopup();
            String mainContainerName = AutowireHelper.getApplicationProperty((String)"fhframework.mainContainer");
            if (mainContainerName == null || mainContainerName.isEmpty()) {
                mainContainerName = "mainForm";
            }
            dialog.setDeclaredContainer(mainContainerName);
            dialog.setFormType(formType.orElse(FormType.MODAL_OVERFLOW));
            dialog.setWidth("md-2");
            dialog.setLabelModelBinding(this.binding(dialogTitle.isPresent() ? dialogTitle.get() : "", (Component)dialog));
            if (dialogId.isPresent()) {
                dialog.setId(dialogId.get());
            }
            dialog.addSubcomponent((Component)new Spacer((Form)dialog));
            Spacer spacer = new Spacer((Form)dialog);
            spacer.setWidth("md-4");
            dialog.addSubcomponent((Component)spacer);
            Canvas canvas = new Canvas((Form)dialog);
            if (severity.isPresent()) {
                canvas.setStyleClasses(severity.get().getBoostrapStyle());
            }
            dialog.addSubcomponent((Component)canvas);
            OutputLabel label = new OutputLabel((Form)dialog);
            label.setWidth("md-12");
            label.setValueBinding(this.binding(messageData.orElse(null), (Component)label));
            canvas.addSubcomponent((Component)label);
            Spacer spacer2 = new Spacer((Form)dialog);
            spacer2.setWidth("md-12");
            spacer2.setHeight("20px");
            dialog.addSubcomponent((Component)spacer2);
            UseCaseContainer useCaseContainer2 = useCaseContainer = session.getUseCaseContainer();
            useCaseContainer2.getClass();
            UseCaseContainer.PopupMessageUseCaseContextMessage popupMessageUseCaseContextMessage = new UseCaseContainer.PopupMessageUseCaseContextMessage(useCaseContainer2, useCaseContainer.getCurrentUseCaseContextOrActionSystemUseCase());
            dialog.setUseCase((IFormUseCaseContext)popupMessageUseCaseContextMessage);
            return dialog;
        }

        private ModelBinding<?> binding(String text, Component component) {
            if (this.bindableText && text != null && !text.isEmpty()) {
                return new AdHocModelBinding(component.getForm(), component, text);
            }
            return new StaticBinding((Object)text);
        }
    }

    public static class TextMessage {
        List<String> lines = new LinkedList<String>();

        public TextMessage(String message) {
            this.lines.add(message);
        }

        public TextMessage() {
        }

        public TextMessage newLine(String message) {
            this.lines.add(message);
            return this;
        }

        public String toMessageString() {
            return this.lines.stream().collect(Collectors.joining("<br/>"));
        }
    }

    public static enum Severity {
        SUCCESS("alert alert-success"),
        INFO("alert alert-info"),
        WARNING("alert alert-warning"),
        ERROR("alert alert-danger");

        String boostrapStyle = "";

        private Severity(String style) {
            this.boostrapStyle = style;
        }

        public String getBoostrapStyle() {
            return this.boostrapStyle;
        }
    }
}

