/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.CompiledBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.generator.CompiledClassesHelper;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.events.I18nFormElement;
import pl.fhframework.format.FhConversionService;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Button;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Styleable;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.utils.WCAGService;

@TemplateControl(tagName="fh-high-contrast-buttons")
@Control(parents={PanelGroup.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.BUTTONS_AND_OTHER, documentationExample=true, value="PanelGroup component responsible for the grouping of buttons.", icon="fa fa-square")
public class HighContrastButtons
extends GroupingComponent<Component>
implements Boundable,
IChangeableByClient,
CompactLayout,
IDesignerEventListener,
IHasBoundableLabel,
I18nFormElement {
    private static final String ATTR_ACTIVE_BUTTON = "activeButton";
    private static final String ATTR_CSS_CLASS = "cssClass";
    public static final String LABEL_ATTR = "label";
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding<String> labelModelBinding;
    @JsonIgnore
    @XMLProperty(value="activeButton")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    @DocumentedComponentAttribute(boundable=true, value="Index of active Button. Default value of active button is 0 - high contrast is not activated.")
    private ModelBinding activeButtonBinding;
    @Autowired
    @JsonIgnore
    WCAGService WCAGService;
    @Autowired
    @JsonIgnore
    private FhConversionService conversionService;
    @Autowired
    @JsonIgnore
    MessageService messageService;
    private int activeButton = 0;
    private String cssClass = "";
    private boolean buttonAdded = false;
    private Button button1 = null;
    private Button button2 = null;

    public HighContrastButtons(Form form) {
        super(form);
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.WCAGService});
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.messageService});
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.conversionService});
        if (this.WCAGService != null) {
            Boolean isHighContrast = this.WCAGService.isHighContrast();
            this.activeButton = isHighContrast != false ? 1 : 0;
        }
    }

    public void updateModel(ValueChange valueChange) {
        String newValue = valueChange.getMainValue();
        int newActiveButton = Integer.parseInt(newValue);
        Boolean isHighContrast = this.WCAGService.isHighContrast();
        this.activeButton = isHighContrast != false ? 1 : 0;
        if (newActiveButton != this.activeButton) {
            this.activeButton = newActiveButton;
            this.updateBindingForValue(newActiveButton, this.activeButtonBinding, this.activeButton);
            if (newActiveButton == 1) {
                this.WCAGService.setHighContrast();
            } else {
                this.WCAGService.setNormalContrast();
            }
        }
    }

    protected ElementChanges updateView() {
        if (this.getSubcomponents().size() == 0 && !this.buttonAdded && this.isInitDone()) {
            this.addSubcomponent((Component)this.createNormalButton());
            this.addSubcomponent((Component)this.createHighContrastButton());
            this.buttonAdded = true;
        }
        ElementChanges elementChanges = super.updateView();
        this.resolveBindingForLabel(elementChanges);
        Boolean isHighContrast = this.WCAGService.isHighContrast();
        if (isHighContrast.booleanValue()) {
            elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)1);
        } else {
            elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)0);
        }
        if (!this.cssClass.equals(this.WCAGService.getCssClassForContrast())) {
            this.cssClass = this.WCAGService.getCssClassForContrast();
            elementChanges.addChange(ATTR_CSS_CLASS, (Object)this.cssClass);
        }
        return elementChanges;
    }

    private void resolveBindingForLabel(ElementChanges elementChanges) {
        if (this.labelModelBinding != null) {
            this.label = this.labelModelBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.label, LABEL_ATTR);
        }
    }

    private String getNormalLabelModelBinding() {
        try {
            return this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.highContrastButtons.normal");
        }
        catch (NullPointerException var2) {
            if (CompiledClassesHelper.isLocalNullPointerException((NullPointerException)var2, (String)this.getForm().getClass().getName(), (String)"getNormalLabelModelBinding")) {
                return null;
            }
            throw var2;
        }
    }

    private String getNormalAriaLabelModelBinding() {
        try {
            return this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.highContrastButtons.normal.ariaLabel");
        }
        catch (NullPointerException var2) {
            if (CompiledClassesHelper.isLocalNullPointerException((NullPointerException)var2, (String)this.getForm().getClass().getName(), (String)"getNormalLabelModelBinding")) {
                return null;
            }
            throw var2;
        }
    }

    private Button createNormalButton() {
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new CompiledBinding("{$.pl.fhframework.model.forms.highContrastButtons.normal}", (String)null, String.class, this::getConversionService, this::getNormalLabelModelBinding, (CompiledBinding.ValueSetter)null));
        button.setAriaLabelBinding((ModelBinding)new CompiledBinding("{$.pl.fhframework.model.forms.highContrastButtons.normal.ariaLabel}", (String)null, String.class, this::getConversionService, this::getNormalAriaLabelModelBinding, (CompiledBinding.ValueSetter)null));
        button.setStyleModelBinding((ModelBinding)new StaticBinding((Object)Styleable.Style.DEFAULT.toValue()));
        button.setStyleClasses("border, mr-2, fh-high-contrast-btn-normal");
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    private String getContrastLabelModelBinding() {
        try {
            return this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.highContrastButtons.hightContrast");
        }
        catch (NullPointerException var2) {
            if (CompiledClassesHelper.isLocalNullPointerException((NullPointerException)var2, (String)this.getForm().getClass().getName(), (String)"getNormalLabelModelBinding")) {
                return null;
            }
            throw var2;
        }
    }

    private String getContrastAriaLabelModelBinding() {
        try {
            return this.messageService.getAllBundles().getMessage("pl.fhframework.model.forms.highContrastButtons.hightContrast.ariaLabel");
        }
        catch (NullPointerException var2) {
            if (CompiledClassesHelper.isLocalNullPointerException((NullPointerException)var2, (String)this.getForm().getClass().getName(), (String)"getNormalLabelModelBinding")) {
                return null;
            }
            throw var2;
        }
    }

    private Button createHighContrastButton() {
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new CompiledBinding("{$.pl.fhframework.model.forms.highContrastButtons.hightContrast}", (String)null, String.class, this::getConversionService, this::getContrastLabelModelBinding, (CompiledBinding.ValueSetter)null));
        button.setAriaLabelBinding((ModelBinding)new CompiledBinding("{$.pl.fhframework.model.forms.highContrastButtons.hightContrast.ariaLabel}", (String)null, String.class, this::getConversionService, this::getContrastAriaLabelModelBinding, (CompiledBinding.ValueSetter)null));
        button.setStyleModelBinding((ModelBinding)new StaticBinding((Object)Styleable.Style.DARK.toValue()));
        button.setStyleClasses("mr-2, fh-high-contrast-btn-high");
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    public void onSessionLanguageChange(String lang) {
        this.refreshView();
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding<String> getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding<String> labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public ModelBinding getActiveButtonBinding() {
        return this.activeButtonBinding;
    }

    @JsonIgnore
    public void setActiveButtonBinding(ModelBinding activeButtonBinding) {
        this.activeButtonBinding = activeButtonBinding;
    }

    public FhConversionService getConversionService() {
        return this.conversionService;
    }

    public int getActiveButton() {
        return this.activeButton;
    }

    public String getCssClass() {
        return this.cssClass;
    }
}

