/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.config;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.model.forms.attribute.HintType;

@Component
public class BasicControlsConfiguration {
    private static BasicControlsConfiguration INSTANCE;
    @Value(value="${fh.web.inputText.maxLength:65535}")
    private Integer inputTextMaxLength;
    @Value(value="${fh.web.tablePaged.pageSizeAsButtons:false}")
    private Boolean tablePagedPageSizeAsButtons;
    @Value(value="${fh.web.tablePaged.pageSizes:5,10,15,25}")
    private String tablePagedPageSizes;
    @Value(value="${fh.web.formElement.hintTpe:STANDARD}")
    private HintType formElementHintType;
    @Value(value="${fh.web.secure.caprcha.sitekey:null}")
    private String captchaSiteKey;
    @Value(value="${fh.web.secure.caprcha.serverkey:null}")
    private String captchaServerKey;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageService messageService;

    @PostConstruct
    void init() {
        INSTANCE = this;
    }

    public static BasicControlsConfiguration getInstance() {
        return INSTANCE;
    }

    public Integer getInputTextMaxLength() {
        return this.inputTextMaxLength;
    }

    public Boolean getTablePagedPageSizeAsButtons() {
        return this.tablePagedPageSizeAsButtons;
    }

    public String getTablePagedPageSizes() {
        return this.tablePagedPageSizes;
    }

    public HintType getFormElementHintType() {
        return this.formElementHintType;
    }

    public String getCaptchaSiteKey() {
        return this.captchaSiteKey;
    }

    public String getCaptchaServerKey() {
        return this.captchaServerKey;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }
}

