/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.formatters;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import pl.fhframework.format.AutoRegisteredFormatter;
import pl.fhframework.format.FhFormatter;

@FhFormatter(value="bigDecimalFormatter2")
public class BigDecimalFormatter2
extends AutoRegisteredFormatter<BigDecimal> {
    private static final int PRECISION = 2;
    private static ThreadLocal<DecimalFormat> customFormat = ThreadLocal.withInitial(() -> new DecimalFormat(){
        {
            this.setGroupingUsed(false);
            this.setParseBigDecimal(true);
            DecimalFormatSymbols pSymbols = this.getDecimalFormatSymbols();
            pSymbols.setDecimalSeparator(',');
            pSymbols.setGroupingSeparator(' ');
            this.setDecimalFormatSymbols(pSymbols);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(2);
            this.setRoundingMode(RoundingMode.DOWN);
        }
    });

    public BigDecimal parse(String s, Locale locale) throws NumberFormatException {
        return new BigDecimal(s).setScale(2, RoundingMode.DOWN);
    }

    public String print(BigDecimal value, Locale locale) {
        String pRetVal = "";
        if (value != null) {
            pRetVal = customFormat.get().format(value);
        }
        return pRetVal;
    }
}

