/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.Optional;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.SplitContainer;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@DesignerControl(defaultWidth=12)
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class, SplitContainer.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, value="Group component is responsible for placing components in one group, that does not intersects with other form components", icon="fa fa-columns")
public class Group
extends GroupingComponent<Component>
implements IDesignerEventListener {
    private static final String ATTR_ON_CLICK = "onClick";
    @XMLProperty
    @DesignerXMLProperty(commonUse=false, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR, priority=100)
    @DocumentedComponentAttribute(value="If the group is clicked that method will be executed. All components inside that group with actions will be invoked first. The action may or may not be propagated to Group. It depends on used component, so use it with caution.")
    private ActionBinding onClick;

    public Group(Form form) {
        super(form);
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ATTR_ON_CLICK.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onClick);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnClick(ActionBinding onClick) {
        this.onClick = onClick;
    }

    public IActionCallbackContext setOnClick(IActionCallback onClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onClick, this::setOnClick);
    }

    public Boolean isDesignDeletable() {
        if (this.getGroupingParentComponent() instanceof SplitContainer) {
            return false;
        }
        return true;
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createNewRow());
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createNewRow());
    }

    private Row createNewRow() {
        Row row = new Row(this.getForm());
        row.setGroupingParentComponent((IGroupingComponent)this);
        row.init();
        return row;
    }

    public ActionBinding getOnClick() {
        return this.onClick;
    }
}

