/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ReflectionUtils;
import pl.fhframework.annotations.RepeaterTraversable;
import pl.fhframework.binding.AdHocModelBinding;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.RowNumberBindingContext;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhFormException;
import pl.fhframework.core.forms.iterators.ISingleIteratorComponentFactory;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Repeater;

public class RepeaterComponentCloner
implements Cloneable,
ISingleIteratorComponentFactory<Repeater> {
    @JsonIgnore
    private static Pattern bindingPatternGroup = Pattern.compile("(\\{[A-Za-z0-9_\\.\\[\\]\\(\\)\\,]+\\})+");
    private static Pattern actionBindingPatternGroup = Pattern.compile("(\\([A-Za-z0-9_\\.]+\\)){1}");

    public List<FormElement> createComponentsForIterator(Repeater myRepeater, IRowNumberOffsetSupplier rowNumberOffset, int index) {
        String collectionBinding = RepeaterComponentCloner.remSpecial(myRepeater.getCollection().getBindingExpression());
        ArrayList<FormElement> newBindedSubcomponents = new ArrayList<FormElement>();
        for (Component component : myRepeater.getRepeatedComponents()) {
            Optional clone = component.clone();
            if (!clone.isPresent()) continue;
            ((Component)clone.get()).setGroupingParentComponent((IGroupingComponent)myRepeater);
            ClonedComponentHolder holder = new ClonedComponentHolder(clone);
            this.processBindingDeep(myRepeater, holder, index, myRepeater.getIterator(), collectionBinding);
            if (holder.getCloneable().get() != clone.get()) {
                holder.getCloneable().get().setGroupingParentComponent((IGroupingComponent)myRepeater);
            }
            newBindedSubcomponents.add((FormElement)holder.getCloneable().get());
        }
        return newBindedSubcomponents;
    }

    protected Optional<String> processBinding(ClonedComponentHolder cloneHolder, String valueBindingOrig, Integer index, String iterator, String binding) {
        String valueBindingCopy = new String(valueBindingOrig);
        StringBuffer valueBindingResult = new StringBuffer();
        Matcher bindingMatcherGroup = bindingPatternGroup.matcher(valueBindingCopy);
        Matcher actionMatcherGroup = actionBindingPatternGroup.matcher(valueBindingCopy);
        Optional<Component> clone = cloneHolder.cloneable;
        boolean bindingProcessed = false;
        if (clone.get() instanceof Repeater && bindingMatcherGroup.toMatchResult().groupCount() > 1) {
            throw new RuntimeException("Two or more bindings in Repeater are prohibited");
        }
        if (bindingMatcherGroup.find()) {
            bindingMatcherGroup.reset();
            while (bindingMatcherGroup.find()) {
                String valueBinding = bindingMatcherGroup.group(1);
                valueBinding = RepeaterComponentCloner.remSpecial(valueBinding);
                boolean iteratorOnPath = valueBinding.contains(iterator + ".");
                boolean endsWithIterator = valueBinding.endsWith(iterator);
                if (!iteratorOnPath && !endsWithIterator) continue;
                if (iteratorOnPath) {
                    valueBinding = "{" + valueBinding.replace(iterator + ".", binding + "[" + index + "].") + "}";
                } else if (endsWithIterator) {
                    valueBinding = "{" + valueBinding.replace(iterator, binding + "[" + index + "]") + "}";
                }
                bindingProcessed = true;
                bindingMatcherGroup.appendReplacement(valueBindingResult, valueBinding);
                if (!(clone.get() instanceof Repeater)) continue;
                ((Repeater)((Object)Repeater.class.cast((Object)clone.get()))).iterationContext = new Repeater.RepeaterIterationContext(index, binding, iterator);
            }
            bindingMatcherGroup.appendTail(valueBindingResult);
        } else if (actionMatcherGroup.find()) {
            actionMatcherGroup.reset();
            while (actionMatcherGroup.find()) {
                boolean endsWithIterator;
                String valueBinding = actionMatcherGroup.group(1);
                boolean iteratorOnPath = (valueBinding = valueBinding.replace("(", "").replace(")", "")).contains(iterator + ".");
                if (!(iteratorOnPath | (endsWithIterator = valueBinding.endsWith(iterator)))) continue;
                if (iteratorOnPath) {
                    valueBinding = valueBinding.replace(iterator + ".", binding + "[" + index + "].");
                } else if (endsWithIterator) {
                    valueBinding = valueBinding.replace(iterator, "(" + binding + "[" + index + "])");
                }
                bindingProcessed = true;
                actionMatcherGroup.appendReplacement(valueBindingResult, valueBinding);
                if (!(clone.get() instanceof Repeater)) continue;
                ((Repeater)((Object)Repeater.class.cast((Object)clone.get()))).iterationContext = new Repeater.RepeaterIterationContext(index, binding, iterator);
            }
            actionMatcherGroup.appendTail(valueBindingResult);
        }
        return bindingProcessed ? Optional.of(valueBindingResult.toString()) : Optional.empty();
    }

    protected void processBindingDeep(Repeater myRepeater, ClonedComponentHolder cloneHolder, Integer index, String iterator, String binding) {
        Optional<Component> freshClone = cloneHolder.cloneable;
        String newComponentId = RepeaterComponentCloner.computeIdOfClonedElement(freshClone, index, myRepeater);
        boolean walkAndProcess = true;
        if (walkAndProcess) {
            ReflectionUtils.FieldCallback resolveBindingFieldCallback = this.createResolveBindingCallback(myRepeater, cloneHolder, index, iterator, binding);
            ReflectionUtils.FieldFilter resolveBindingFieldFilter = RepeaterComponentCloner.createResolveBindingFieldFilter();
            ReflectionUtils.FieldCallback changeClonedElementNameFieldCallback = RepeaterComponentCloner.createChangeClonedElementNameFieldCallback(freshClone, index, myRepeater);
            freshClone.get().getBindingContext().getRowNumberBindingContexts().add(new RowNumberBindingContext(iterator, index + 1));
            freshClone.get().getBindingContext().getRowNumberBindingContexts().addAll(myRepeater.getBindingContext().getRowNumberBindingContexts());
            ReflectionUtils.doWithFields(freshClone.get().getClass(), (ReflectionUtils.FieldCallback)changeClonedElementNameFieldCallback, field -> Objects.equals("id", field.getName().toLowerCase()));
            ReflectionUtils.doWithFields(freshClone.get().getClass(), (ReflectionUtils.FieldCallback)resolveBindingFieldCallback, (ReflectionUtils.FieldFilter)resolveBindingFieldFilter);
        }
        if (walkAndProcess && freshClone.get() instanceof IGroupingComponent) {
            List subcomponents = ((IGroupingComponent)freshClone.get()).getSubcomponents();
            ArrayList subcomponentsCopy = new ArrayList(subcomponents);
            for (int i = 0; i < subcomponentsCopy.size(); ++i) {
                Component iterated = (Component)subcomponentsCopy.get(i);
                ClonedComponentHolder iteratedHolder = new ClonedComponentHolder(Optional.of(iterated));
                this.processBindingDeep(myRepeater, iteratedHolder, index, iterator, binding);
                subcomponents.remove(i);
                subcomponents.add(i, iteratedHolder.getCloneable().get());
            }
        }
    }

    private ReflectionUtils.FieldCallback createResolveBindingCallback(Repeater myRepeater, ClonedComponentHolder cloneHolder, Integer index, String iterator, String binding) {
        return field -> {
            boolean isPrivate;
            Optional<Component> clone = cloneHolder.getCloneable();
            boolean bl = isPrivate = !field.isAccessible();
            if (isPrivate) {
                field.setAccessible(true);
            }
            ModelBinding valueBindingOrigObj = null;
            String valueBindingOrig = null;
            if (field.isAnnotationPresent(RepeaterTraversable.class)) {
                if (!FormElement.class.isAssignableFrom(field.getType())) throw new FhFormException("Field: " + field.getType() + " of " + field.getType().getSimpleName() + " is not instanceof FormElement");
                Component componentToBeTraversed = (Component)Component.class.cast(ReflectionUtils.getField((Field)field, (Object)clone.get()));
                this.processBindingDeep(myRepeater, new ClonedComponentHolder(Optional.of(componentToBeTraversed)), index, iterator, binding);
            } else if (ModelBinding.class.isAssignableFrom(field.getType())) {
                ModelBinding modelBinding = (ModelBinding)ReflectionUtils.getField((Field)field, (Object)clone.get());
                if (modelBinding != null) {
                    valueBindingOrigObj = modelBinding;
                    valueBindingOrig = modelBinding.getBindingExpression();
                }
            } else {
                valueBindingOrig = (String)ReflectionUtils.getField((Field)field, (Object)clone.get());
            }
            if (valueBindingOrig == null || !bindingPatternGroup.matcher(valueBindingOrig).find() && !this.isAction(valueBindingOrig)) return;
            Optional<String> bindingProcessed = this.processBinding(cloneHolder, valueBindingOrig, index, iterator, binding);
            if (!bindingProcessed.isPresent()) {
                Repeater chainedGroup = myRepeater;
                while (chainedGroup != null) {
                    if (chainedGroup instanceof Repeater) {
                        Repeater chainedRepeater = (Repeater)((Object)((Object)Repeater.class.cast((Object)chainedGroup)));
                        if (chainedRepeater.iterationContext != null) {
                            bindingProcessed = this.processBinding(cloneHolder, valueBindingOrig, chainedRepeater.iterationContext.iterationIndex, chainedRepeater.iterationContext.iterationIterator, chainedRepeater.iterationContext.iterationBinding);
                        }
                    }
                    if (bindingProcessed.isPresent()) break;
                    chainedGroup = ((FormElement)FormElement.class.cast((Object)chainedGroup)).getGroupingParentComponent();
                }
            }
            if (!bindingProcessed.isPresent()) return;
            if (ModelBinding.class.isAssignableFrom(field.getType())) {
                ModelBinding modelBinding = (ModelBinding)ReflectionUtils.getField((Field)field, (Object)clone.get());
                if (valueBindingOrigObj instanceof StaticBinding) return;
                ReflectionUtils.setField((Field)field, (Object)clone.get(), (Object)new AdHocModelBinding(myRepeater.getForm(), clone.get(), bindingProcessed.get()));
                return;
            } else {
                ReflectionUtils.setField((Field)field, (Object)clone.get(), (Object)bindingProcessed.get());
            }
        };
    }

    private boolean isAction(String binding) {
        return binding.contains("(");
    }

    static ReflectionUtils.FieldFilter createResolveBindingFieldFilter() {
        return field -> !Modifier.isStatic(field.getModifiers()) && (field.getType().equals(String.class) || field.isAnnotationPresent(RepeaterTraversable.class) || field.getType().isAnnotationPresent(RepeaterTraversable.class));
    }

    private static ReflectionUtils.FieldCallback createChangeClonedElementNameFieldCallback(Optional<Component> clone, Integer index, Repeater thisRepeater) {
        return field -> {
            boolean isPrivate;
            String parentGluePath = "";
            Repeater container = thisRepeater;
            while (container != null && !Objects.equals(((Object)((Object)container)).getClass(), Form.class)) {
                if (container instanceof Repeater) {
                    Repeater parentRepeater = container;
                    parentGluePath = parentRepeater.getId() + "_" + parentGluePath;
                    break;
                }
                container = ((FormElement)container).getGroupingParentComponent();
            }
            if (parentGluePath.endsWith("_")) {
                parentGluePath = parentGluePath.substring(0, parentGluePath.lastIndexOf("_"));
            }
            boolean bl = isPrivate = !field.isAccessible();
            if (isPrivate) {
                field.setAccessible(true);
            }
            String val = ReflectionUtils.getField((Field)field, clone.get()).toString();
            ReflectionUtils.setField((Field)field, clone.get(), (Object)(val + (!parentGluePath.isEmpty() ? "_" + parentGluePath : "") + "_" + index + ""));
            if (clone.get() instanceof FormElement) {
                thisRepeater.getForm().addToElementIdToFormElement((FormElement)clone.get());
            }
        };
    }

    private static String computeIdOfClonedElement(Optional<Component> originalComponent, Integer index, Repeater thisRepeater) {
        String parentGluePath = "";
        Repeater container = thisRepeater;
        while (container != null && !Objects.equals(((Object)((Object)container)).getClass(), Form.class)) {
            if (container instanceof Repeater) {
                Repeater parentRepeater = container;
                parentGluePath = parentRepeater.getId() + "_" + parentGluePath;
                break;
            }
            container = ((FormElement)container).getGroupingParentComponent();
        }
        if (parentGluePath.endsWith("_")) {
            parentGluePath = parentGluePath.substring(0, parentGluePath.lastIndexOf("_"));
        }
        return originalComponent.get().getId() + (!parentGluePath.isEmpty() ? "_" + parentGluePath : "") + "_" + index + "";
    }

    protected static String remSpecial(String binding) {
        return binding.replace("{", "").replace("}", "");
    }

    private static class ClonedComponentHolder {
        Optional<Component> cloneable;

        public Optional<Component> getCloneable() {
            return this.cloneable;
        }

        public void setCloneable(Optional<Component> cloneable) {
            this.cloneable = cloneable;
        }

        public ClonedComponentHolder(Optional<Component> cloneable) {
            this.cloneable = cloneable;
        }
    }
}

