/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.ImageArea;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.model.LabelPosition;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.widgets.Widget;

@DesignerControl(defaultWidth=6)
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Group.class, Widget.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.IMAGE_HTML_MD, documentationExample=true, value="Image component for displaying image and marking points on it (optionally)", icon="fa fa-image")
public class Image
extends FormElement
implements TableComponent<Image> {
    public static final String ATTR_SRC = "src";
    public static final String ATTR_ALT = "alt";
    public static final String ATTR_ON_AREA_CLICK = "onAreaClick";
    public static final String ATTR_ON_CLICK = "onClick";
    public static final String ATTR_IMAGE_AREAS = "imageAreas";
    public static final String ATTR_LABEL = "label";
    private String src;
    @JsonIgnore
    @XMLProperty(required=true, value="src")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Component source")
    private ModelBinding<String> srcModelBinding;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If the image is clicked that method will be executed. Action is fired, while component is active.")
    private ActionBinding onClick;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If the image area is clicked that method will be executed. Action is fired, while component is active.")
    private ActionBinding onAreaClick;
    @JsonIgnore
    @XMLProperty(value="imageAreas")
    @DocumentedComponentAttribute(value="Component area parameter containing id and coordinates")
    private String imageAreasAttribute;
    private List<ImageArea> imageAreas;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=95)
    @DocumentedComponentAttribute(value="Defines position of a label. Position is one of: up, down, left, right.")
    private LabelPosition labelPosition;
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding labelModelBinding;
    private String alt;
    @JsonIgnore
    @XMLProperty(required=true, value="alt")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Component alternative information/description.")
    private ModelBinding<String> altModelBinding;

    public Image(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.imageAreas = this.parseAreas(this.imageAreasAttribute);
    }

    private List<ImageArea> parseAreas(String map) {
        String[] areasString;
        if (map == null) {
            return null;
        }
        ArrayList<ImageArea> result = new ArrayList<ImageArea>();
        for (String areaString : areasString = map.replace(" ", "").split(";")) {
            try {
                areaString = areaString.substring(1, areaString.length() - 1);
                String[] parameters = areaString.split(",");
                String id = parameters[0].substring(1);
                int xl = Integer.parseInt(parameters[1]);
                int yl = Integer.parseInt(parameters[2]);
                int xp = Integer.parseInt(parameters[3]);
                int yp = Integer.parseInt(parameters[4]);
                result.add(new ImageArea(id, xl, yl, xp, yp));
            }
            catch (Exception exc) {
                FhLogger.error((String)"Error in parsing of area: '{}' image '{}'!", (Object[])new Object[]{areaString, this.getId(), exc});
            }
        }
        return result;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (eventData.getEventType().startsWith(ATTR_ON_AREA_CLICK)) {
            String[] splitEvent = eventData.getEventType().split("#");
            eventData.setEventType(splitEvent[0]);
            if (splitEvent.length == 2) {
                eventData.setOptionalValue((Object)splitEvent[1]);
            }
            return Optional.ofNullable(this.onAreaClick);
        }
        if (ATTR_ON_CLICK.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onClick);
        }
        return super.getEventHandler(eventData);
    }

    public ElementChanges updateView() {
        ElementChanges elementChange = super.updateView();
        if (this.srcModelBinding != null) {
            this.src = this.srcModelBinding.resolveValueAndAddChanges((FormElement)this, elementChange, this.src, ATTR_SRC);
        }
        if (this.altModelBinding != null) {
            this.alt = this.altModelBinding.resolveValueAndAddChanges((FormElement)this, elementChange, this.alt, ATTR_ALT);
        }
        if (this.labelModelBinding != null) {
            this.label = this.labelModelBinding.resolveValueAndAddChanges((FormElement)this, elementChange, this.label, ATTR_LABEL);
        }
        return elementChange;
    }

    @Override
    public Image createNewSameComponent() {
        return new Image(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, Image clone) {
        TableComponent.super.doCopy(table, iteratorReplacements, clone);
        clone.setSrc(this.getSrc());
        clone.setAlt(this.getAlt());
        clone.setOnClick(table.getRowBinding(this.getOnClick(), (Component)clone, iteratorReplacements));
        clone.setOnAreaClick(table.getRowBinding(this.getOnAreaClick(), (Component)clone, iteratorReplacements));
        clone.setLabelModelBinding(table.getRowBinding(this.getLabelModelBinding(), (Component)clone, iteratorReplacements));
        clone.setImageAreasAttribute(this.getImageAreasAttribute());
    }

    public void setOnClick(ActionBinding onClick) {
        this.onClick = onClick;
    }

    public IActionCallbackContext setOnClick(IActionCallback onClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onClick, this::setOnClick);
    }

    public void setOnAreaClick(ActionBinding onAreaClick) {
        this.onAreaClick = onAreaClick;
    }

    public IActionCallbackContext setOnAreaClick(IActionCallback onAreaClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onAreaClick, this::setOnAreaClick);
    }

    public List<ImageArea> getImageAreas() {
        return this.imageAreas;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setImageAreas(List<ImageArea> imageAreas) {
        this.imageAreas = imageAreas;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public String getSrc() {
        return this.src;
    }

    public ModelBinding<String> getSrcModelBinding() {
        return this.srcModelBinding;
    }

    public void setSrcModelBinding(ModelBinding<String> srcModelBinding) {
        this.srcModelBinding = srcModelBinding;
    }

    public ActionBinding getOnClick() {
        return this.onClick;
    }

    public ActionBinding getOnAreaClick() {
        return this.onAreaClick;
    }

    public String getImageAreasAttribute() {
        return this.imageAreasAttribute;
    }

    public void setImageAreasAttribute(String imageAreasAttribute) {
        this.imageAreasAttribute = imageAreasAttribute;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getAlt() {
        return this.alt;
    }

    public ModelBinding<String> getAltModelBinding() {
        return this.altModelBinding;
    }

    public void setAltModelBinding(ModelBinding<String> altModelBinding) {
        this.altModelBinding = altModelBinding;
    }
}

