/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.IDesignerEventListener;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(readOnlyInDesigner=true)}, property="hintType")
@TemplateControl(tagName="fh-tab-container")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="TabContainer component which represents a containrt containing a single tabs", icon="fas fa-window-maximize")
public class TabContainer
extends GroupingComponent<Tab>
implements IChangeableByClient,
Boundable,
CompactLayout,
IDesignerEventListener {
    public static final String TYPE_NAME = "TabContainer";
    public static final String ATTR_ACTIVE_TAB_INDEX = "activeTabIndex";
    public static final String ATTR_ACTIVE_TAB_ID = "activeTabId";
    public static final String ON_TAB_CHANGE = "onTabChange";
    private int activeTabIndex = -1;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on clicking on tab, that method will be executed. This method fires, when component loses focus. Warning!!if possible for component, use onInput!!")
    private ActionBinding onTabChange;
    @JsonIgnore
    @XMLProperty(value="activeTabIndex")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    @DocumentedComponentAttribute(defaultValue="0", boundable=true, value="Represents the index of the active tab. If 'activeTabId' binding is also used, then this attribute is read-only")
    private ModelBinding modelBinding;
    @JsonIgnore
    @XMLProperty(value="activeTabId")
    @DesignerXMLProperty(allowedTypes={String.class})
    @DocumentedComponentAttribute(boundable=true, value="Represents the identification of the active tab. The attribute has precedence over 'activeTabIndex' if both are used")
    private ModelBinding tabIdBinding;

    public TabContainer(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        if (this.tabIdBinding != null) {
            BindingResult bindingResult = this.tabIdBinding.getBindingResult();
            if (bindingResult != null) {
                Object activeTabIdValue = bindingResult.getValue();
                String convertedActiveTabValue = (String)this.convertValue(activeTabIdValue, String.class);
                if (convertedActiveTabValue != null) {
                    this.activeTabIndex = this.calcTabIndexById(convertedActiveTabValue);
                }
            } else {
                String convertedActiveTabValue = (String)this.convertValue(this.tabIdBinding.getBindingExpression(), String.class);
                if (convertedActiveTabValue != null) {
                    this.activeTabIndex = this.calcTabIndexById(convertedActiveTabValue);
                }
            }
        } else if (this.modelBinding != null) {
            BindingResult bindingResult = this.modelBinding.getBindingResult();
            if (bindingResult != null) {
                Object activeTabIndexValue = bindingResult.getValue();
                Integer convertedActiveTabValue = (Integer)this.convertValue(activeTabIndexValue, Integer.class);
                if (convertedActiveTabValue != null) {
                    this.activeTabIndex = convertedActiveTabValue;
                }
            } else {
                Integer convertedActiveTabValue = (Integer)this.convertValue(this.modelBinding.getBindingExpression(), Integer.class);
                if (convertedActiveTabValue != null) {
                    this.activeTabIndex = convertedActiveTabValue;
                }
            }
        }
        if (this.activeTabIndex == -1) {
            this.activeTabIndex = 0;
            if (!this.getForm().isDesignMode()) {
                this.updateActiveTab();
            }
        }
        if (!this.getForm().isDesignMode()) {
            this.validateActiveTabIndexVisibility();
        }
    }

    public void validateActiveTabIndexVisibility() {
        Boolean hiddenTab;
        List subcomponents = this.getSubcomponents();
        Tab activeTab = (Tab)((Object)subcomponents.get(this.activeTabIndex));
        if (activeTab.getAvailabilityModelBinding() != null && (hiddenTab = Boolean.valueOf(activeTab.getAvailabilityModelBinding().getBindingExpression().equals("HIDDEN"))).booleanValue()) {
            this.modelBinding = null;
            this.activeTabIndex = this.getFirstVisibleTab(this.activeTabIndex + 1);
        }
    }

    public Integer getFirstVisibleTab(Integer activeTabIndex) {
        List subcomponents = this.getSubcomponents();
        Integer subcomponentsLength = subcomponents.size();
        for (int i = activeTabIndex.intValue(); i < subcomponentsLength; ++i) {
            Tab activeTab = (Tab)((Object)subcomponents.get(i));
            if (activeTab.getAvailabilityModelBinding() != null) {
                Boolean tabAvailable = !activeTab.getAvailabilityModelBinding().getBindingExpression().equals("HIDDEN");
                if (!tabAvailable.booleanValue()) continue;
                return i;
            }
            return i;
        }
        return activeTabIndex;
    }

    private int calcTabIndexById(String convertedActiveTabValue) {
        for (int i = 0; i < this.getSubcomponents().size(); ++i) {
            if (!Objects.equals(((Tab)((Object)this.getSubcomponents().get(i))).getId(), convertedActiveTabValue)) continue;
            return i;
        }
        return -1;
    }

    private void updateActiveTab() {
        if (this.modelBinding != null) {
            this.updateBindingForValue(this.activeTabIndex, this.modelBinding, this.activeTabIndex);
        }
        if (this.tabIdBinding != null) {
            String tabIdValue = ((Tab)((Object)this.getSubcomponents().get(this.activeTabIndex))).getId();
            this.updateBindingForValue(tabIdValue, this.tabIdBinding, this.tabIdBinding.getBindingExpression());
        }
    }

    public String getType() {
        return TYPE_NAME;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_TAB_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onTabChange);
        }
        return super.getEventHandler(eventData);
    }

    public void updateModel(ValueChange valueChange) {
        String newValue = valueChange.getMainValue();
        int newActiveTabIndex = Integer.parseInt(newValue);
        if (newActiveTabIndex != this.activeTabIndex) {
            this.activeTabIndex = newActiveTabIndex;
        }
        this.updateActiveTab();
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        int newActiveTabIndex = this.activeTabIndex;
        if (this.tabIdBinding != null) {
            Object value;
            BindingResult bindingResult = this.tabIdBinding.getBindingResult();
            if (bindingResult != null && (value = bindingResult.getValue()) != null) {
                newActiveTabIndex = this.calcTabIndexById((String)this.convertValue(value, String.class));
            }
        } else {
            Object value;
            BindingResult bindingResult;
            BindingResult bindingResult2 = bindingResult = this.modelBinding != null ? this.modelBinding.getBindingResult() : null;
            if (bindingResult != null && (value = bindingResult.getValue()) != null) {
                newActiveTabIndex = (Integer)this.convertValue(value, Integer.class);
            }
        }
        if (newActiveTabIndex != this.activeTabIndex) {
            this.refreshView();
            if (newActiveTabIndex == -1) {
                newActiveTabIndex = 0;
                this.updateActiveTab();
            }
            this.activeTabIndex = newActiveTabIndex;
            elementChanges.addChange(ATTR_ACTIVE_TAB_INDEX, (Object)this.activeTabIndex);
        }
        return elementChanges;
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleTab(this.getSubcomponents().size() + 1, spacerService));
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleTab(1, spacerService));
        this.addSubcomponent((Component)this.createExampleTab(2, spacerService));
    }

    private Tab createExampleTab(int nameSuffix, SpacerService spacerService) {
        Tab tab = new Tab(this.getForm());
        tab.setLabelModelBinding((ModelBinding)new StaticBinding((Object)("Tab " + nameSuffix)));
        tab.setGroupingParentComponent((IGroupingComponent)this);
        tab.addSubcomponent((Component)tab.createNewRow());
        tab.init();
        return tab;
    }

    public void setOnTabChange(ActionBinding onTabChange) {
        this.onTabChange = onTabChange;
    }

    public IActionCallbackContext setOnTabChange(IActionCallback onTabChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onTabChange, this::setOnTabChange);
    }

    public boolean isModificationEvent(String eventType) {
        if (ON_TAB_CHANGE.equals(eventType)) {
            return false;
        }
        return super.isModificationEvent(eventType);
    }

    public int getActiveTabIndex() {
        return this.activeTabIndex;
    }

    public ActionBinding getOnTabChange() {
        return this.onTabChange;
    }

    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }

    public ModelBinding getTabIdBinding() {
        return this.tabIdBinding;
    }

    public void setTabIdBinding(ModelBinding tabIdBinding) {
        this.tabIdBinding = tabIdBinding;
    }
}

