/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.Map;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.TableOptimized;

public interface TableComponent<T extends FormElement> {
    public T createNewSameComponent();

    default public T getCopy(Table table, Map<String, String> iteratorReplacements) {
        T clone = this.createNewSameComponent();
        this.doCopy(table, iteratorReplacements, clone);
        return clone;
    }

    default public T getCopy(TableOptimized table, Map<String, String> iteratorReplacements) {
        T clone = this.createNewSameComponent();
        this.doCopy(table, iteratorReplacements, clone);
        return clone;
    }

    default public void doCopy(Table table, Map<String, String> iteratorReplacements, T clone) {
        FormElement thisElement = (FormElement)this;
        clone.setId(thisElement.getId());
        clone.setAvailabilityModelBinding(table.getRowBinding(thisElement.getAvailabilityModelBinding(), (Component)clone, iteratorReplacements));
        clone.setHeight(thisElement.getHeight());
        clone.setWidth(thisElement.getWidth());
        clone.setHorizontalAlign(thisElement.getHorizontalAlign());
        clone.setVerticalAlign(thisElement.getVerticalAlign());
        clone.setStyleClasses(thisElement.getStyleClasses());
        clone.setHintBinding(table.getRowBinding(thisElement.getHintBinding(), (Component)clone, iteratorReplacements));
    }

    default public void doCopy(TableOptimized table, Map<String, String> iteratorReplacements, T clone) {
        FormElement thisElement = (FormElement)this;
        clone.setId(thisElement.getId());
        clone.setAvailabilityModelBinding(table.getRowBinding(thisElement.getAvailabilityModelBinding(), (Component)clone, iteratorReplacements));
        clone.setHeight(thisElement.getHeight());
        clone.setWidth(thisElement.getWidth());
        clone.setHorizontalAlign(thisElement.getHorizontalAlign());
        clone.setVerticalAlign(thisElement.getVerticalAlign());
        clone.setStyleClasses(thisElement.getStyleClasses());
        clone.setHintBinding(table.getRowBinding(thisElement.getHintBinding(), (Component)clone, iteratorReplacements));
    }
}

