/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputFieldWithKeySupport;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@TemplateControl(tagName="fh-input-date")
@DesignerControl(defaultWidth=3)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component responsible for displaying field, where user can set only date.", icon="fa fa-calendar")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Group.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@OverridenPropertyAnnotations(property="modelBinding", designerXmlProperty={@DesignerXMLProperty(allowedTypes={LocalDate.class, String.class}, commonUse=true, previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=80, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)})
public class InputDate
extends BaseInputFieldWithKeySupport {
    @XMLProperty
    @DocumentedComponentAttribute(value="Date format, may be one of following described here: http://momentjs.com/docs/#/displaying/format/")
    private String format;
    @XMLProperty
    @DocumentedComponentAttribute(value="Should mask characters be added just in time typing.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private Boolean maskDynamic;
    @XMLProperty
    @DocumentedComponentAttribute(value="Should today be highlighted in datepicker.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private Boolean highlightToday;
    @XMLProperty(defaultValue="false")
    @DocumentedComponentAttribute(value="Creates interactive mask for user")
    private boolean maskEnabled;
    @XMLProperty
    @DocumentedComponentAttribute(value="Is date valid.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=96)
    private ModelBinding<Boolean> invalidDate;

    public InputDate(Form container) {
        super(container);
    }

    @Override
    public InputDate createNewSameComponent() {
        return new InputDate(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        InputDate clone = (InputDate)baseClone;
        clone.setMaskDynamic(this.getMaskDynamic());
        clone.setHighlightToday(this.getHighlightToday());
        clone.setFormat(this.getFormat());
    }

    @Override
    protected void processCoversionException(FhBindingException cfe) {
    }

    protected void processInvalidDateInformation() {
        if (this.invalidDate != null) {
            this.updateBindingForValue(!this.isValidConversion(), this.invalidDate, this.invalidDate.getBindingExpression(), Optional.empty());
        }
    }

    protected boolean areModelValuesTheSame(Object firstValue, Object secondValue) {
        return !this.isValidConversion() || super.areValuesTheSame(firstValue, secondValue);
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        super.updateModel(valueChange);
        this.processInvalidDateInformation();
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        return elementChanges;
    }

    @Override
    protected boolean processValueBinding(ElementChanges elementChanges) {
        boolean hasChange = super.processValueBinding(elementChanges);
        if (hasChange) {
            this.validConversion = true;
            if (this.invalidDate != null) {
                this.updateBindingForValue(!this.isValidConversion(), this.invalidDate, this.invalidDate.getBindingExpression(), Optional.empty());
            }
        }
        return hasChange;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Boolean getMaskDynamic() {
        return this.maskDynamic;
    }

    public void setMaskDynamic(Boolean maskDynamic) {
        this.maskDynamic = maskDynamic;
    }

    public Boolean getHighlightToday() {
        return this.highlightToday;
    }

    public void setHighlightToday(Boolean highlightToday) {
        this.highlightToday = highlightToday;
    }

    public boolean isMaskEnabled() {
        return this.maskEnabled;
    }

    public void setMaskEnabled(boolean maskEnabled) {
        this.maskEnabled = maskEnabled;
    }

    public ModelBinding<Boolean> getInvalidDate() {
        return this.invalidDate;
    }

    public void setInvalidDate(ModelBinding<Boolean> invalidDate) {
        this.invalidDate = invalidDate;
    }
}

