/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Optional;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedAttributesHolder;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.attributes.AttributeHolder;
import pl.fhframework.model.forms.attributes.AttributeHolderBuilder;
import pl.fhframework.model.forms.attributes.grid.EditModeAttribute;

@Control(parents={PanelGroup.class, Row.class, Form.class, Group.class}, canBeDesigned=true)
public class Dashboard
extends GroupingComponent<Component>
implements IChangeableByClient {
    @JsonUnwrapped
    @DocumentedAttributesHolder(attributeClasses={EditModeAttribute.class})
    private AttributeHolder attributeHolder;
    @JsonIgnore
    @XMLProperty(value="editMode")
    private ModelBinding editModeBinding;
    @JsonIgnore
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(value="onToggleEdit")
    private ActionBinding onToggleEdit;
    @JsonIgnore
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(value="onToggleAdd")
    private ActionBinding onToggleAdd;

    public Dashboard(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.attributeHolder = new AttributeHolderBuilder().attribute(new EditModeAttribute(this.getForm(), (Component)this, this.editModeBinding)).build();
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.attributeHolder.updateView((Component)this, elementChanges);
        return elementChanges;
    }

    public void updateModel(ValueChange valueChange) {
        this.attributeHolder.updateModel((Component)this.getForm(), valueChange);
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if ("onToggleEdit".equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onToggleEdit);
        }
        if ("onToggleAdd".equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onToggleAdd);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnToggleEdit(ActionBinding onToggleEdit) {
        this.onToggleEdit = onToggleEdit;
    }

    public IActionCallbackContext setOnToggleEdit(IActionCallback onToggleEdit) {
        return CallbackActionBinding.createAndSet((IActionCallback)onToggleEdit, this::setOnToggleEdit);
    }

    public void setOnToggleAdd(ActionBinding onToggleAdd) {
        this.onToggleAdd = onToggleAdd;
    }

    public IActionCallbackContext setOnToggleAdd(IActionCallback onToggleAdd) {
        return CallbackActionBinding.createAndSet((IActionCallback)onToggleAdd, this::setOnToggleAdd);
    }

    public AttributeHolder getAttributeHolder() {
        return this.attributeHolder;
    }

    public ModelBinding getEditModeBinding() {
        return this.editModeBinding;
    }

    @JsonIgnore
    public void setEditModeBinding(ModelBinding editModeBinding) {
        this.editModeBinding = editModeBinding;
    }

    public ActionBinding getOnToggleEdit() {
        return this.onToggleEdit;
    }

    public ActionBinding getOnToggleAdd() {
        return this.onToggleAdd;
    }
}

