/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.model.LabelPosition;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.widgets.Widget;
import pl.fhframework.subsystems.ModuleRegistry;

@DesignerControl(defaultWidth=12)
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class, Widget.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.IMAGE_HTML_MD, documentationExample=true, value="Md file viewer component for displaying *.md files. Allow inside navigation to other md file.", icon="fa fa-eye")
public class MdFileViewer
extends FormElement
implements TableComponent<MdFileViewer> {
    public static final String ATTR_SRC = "src";
    public static final String ATTR_LABEL = "label";
    private String src;
    @JsonIgnore
    @XMLProperty(required=true, value="src")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Component source. Relative path to md file.")
    private ModelBinding<String> srcModelBinding;
    @XMLProperty
    @DocumentedComponentAttribute(boundable=true, value="Module for md files. Represent base module for relatives urls to other md files.")
    private String moduleId;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Base path for md files placed in resources. Represent base path for relatives urls to other md files.")
    private String resourceBasePath;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=95)
    @DocumentedComponentAttribute(value="Defines position of a label. Position is one of: up, down, left, right.")
    private LabelPosition labelPosition;
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - FH Markup Language.")
    private ModelBinding labelModelBinding;

    public MdFileViewer(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.setModuleId(ModuleRegistry.getModuleId(this.getForm().getClass()));
    }

    public ElementChanges updateView() {
        ElementChanges elementChange = super.updateView();
        if (this.srcModelBinding != null) {
            this.src = this.srcModelBinding.resolveValueAndAddChanges((FormElement)this, elementChange, this.src, ATTR_SRC);
        }
        if (this.labelModelBinding != null) {
            this.label = this.labelModelBinding.resolveValueAndAddChanges((FormElement)this, elementChange, this.label, ATTR_LABEL);
        }
        return elementChange;
    }

    @Override
    public MdFileViewer createNewSameComponent() {
        return new MdFileViewer(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, MdFileViewer clone) {
        TableComponent.super.doCopy(table, iteratorReplacements, clone);
        clone.setSrc(this.getSrc());
        clone.setLabelModelBinding(table.getRowBinding(this.getLabelModelBinding(), (Component)clone, iteratorReplacements));
        clone.setModuleId(this.getModuleId());
        clone.setResourceBasePath(this.getResourceBasePath());
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSrc() {
        return this.src;
    }

    public ModelBinding<String> getSrcModelBinding() {
        return this.srcModelBinding;
    }

    @JsonIgnore
    public void setSrcModelBinding(ModelBinding<String> srcModelBinding) {
        this.srcModelBinding = srcModelBinding;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    public void setResourceBasePath(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }
}

