/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.OverridenPropertyAnnotationsList;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@OverridenPropertyAnnotationsList(value={@OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(skip=true)}, property="value"), @OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(skip=true)}, property="modelBinding"), @OverridenPropertyAnnotations(designerXmlProperty={@DesignerXMLProperty(skip=true)}, property="rawValue")})
@DesignerControl(defaultWidth=12)
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.IMAGE_HTML_MD, documentationExample=true, value="Visual HTML text editor. Allows visual editing of text in HTML markup.", icon="fa fa-eye")
public class HtmlEditor
extends BaseInputField {
    public static final String ATTR_TEXT = "text";
    @JsonIgnore
    @XMLProperty(required=true, value="text")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Text to edit.")
    private ModelBinding<String> textModelBinding;
    private String text;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=93)
    private String formatter;

    public HtmlEditor(Form form) {
        super(form);
    }

    @Override
    public void init() {
        BindingResult bindingResult;
        super.init();
        if (this.textModelBinding != null && (bindingResult = this.textModelBinding.getBindingResult()) != null) {
            this.text = this.convertBindingValueToString(bindingResult);
        }
    }

    @Override
    public ElementChanges updateView() {
        BindingResult bindingResult;
        ElementChanges elementChanges = super.updateView();
        if (this.textModelBinding != null && (bindingResult = this.textModelBinding.getBindingResult()) != null) {
            String newLabelValue = (String)bindingResult.getValue();
            if (this.formatter != null) {
                newLabelValue = this.getForm().convertValueToString((Object)newLabelValue, this.formatter);
            }
            if (!this.areValuesTheSame(newLabelValue, this.text)) {
                this.text = newLabelValue;
                elementChanges.addChange(ATTR_TEXT, (Object)this.text);
            }
        }
        return elementChanges;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        String newText = valueChange.getStringAttribute(ATTR_TEXT);
        if (!Objects.equals(this.text, newText)) {
            this.text = newText;
            this.updateBindingForValue(newText, this.textModelBinding, newText, Optional.ofNullable(this.formatter));
        }
    }

    @Override
    public HtmlEditor createNewSameComponent() {
        return new HtmlEditor(this.getForm());
    }

    public void setText(String text) {
        this.text = text;
    }

    public ModelBinding<String> getTextModelBinding() {
        return this.textModelBinding;
    }

    @JsonIgnore
    public void setTextModelBinding(ModelBinding<String> textModelBinding) {
        this.textModelBinding = textModelBinding;
    }

    public String getText() {
        return this.text;
    }

    public String getFormatter() {
        return this.formatter;
    }

    @JsonIgnore
    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }
}

