/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Button;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.IDesignerEventListener;

@TemplateControl(tagName="fh-button-group")
@Control(parents={PanelGroup.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.BUTTONS_AND_OTHER, documentationExample=true, value="PanelGroup component responsible for the grouping of buttons.", icon="fa fa-square")
public class ButtonGroup
extends GroupingComponent<FormElement>
implements Boundable,
IChangeableByClient,
CompactLayout,
IDesignerEventListener {
    private static final String ATTR_ACTIVE_BUTTON = "activeButton";
    public static final String ATTR_ON_BUTTON_CHANGE = "onButtonChange";
    private static final String DEFAULT_ACTION_NAME = "-";
    private int activeButton = -1;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(defaultValue="-")
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on clicking on button, that method will be executed. This method fires, when button is clicked.")
    private ActionBinding onButtonChange;
    @JsonIgnore
    @XMLProperty(value="activeButton")
    @DesignerXMLProperty(allowedTypes={Integer.class})
    @DocumentedComponentAttribute(boundable=true, value="Index of active Button. Default value of active button is -1, that means ButtonGroup does not have active button by default.")
    private ModelBinding activeButtonBinding;
    @XMLProperty
    @DocumentedComponentAttribute(value="Flag decides if margin should be displayed or not.", defaultValue="false")
    private boolean margin;

    public ButtonGroup(Form form) {
        super(form);
    }

    public void updateModel(ValueChange valueChange) {
        String newValue = valueChange.getMainValue();
        int newActiveButton = Integer.parseInt(newValue);
        if (newActiveButton != this.activeButton) {
            this.activeButton = newActiveButton;
            this.updateBindingForValue(newActiveButton, this.activeButtonBinding, this.activeButton);
        }
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.activeButtonBinding != null) {
            Object value;
            BindingResult bindingResult = this.activeButtonBinding.getBindingResult();
            int numberOfButtons = this.getSubcomponents().size();
            if (bindingResult != null && (value = bindingResult.getValue()) != null) {
                int newActiveButton = (Integer)this.convertValue(value, Integer.class);
                this.activeButton = newActiveButton > numberOfButtons - 1 ? new Integer(-1) : newActiveButton;
                this.refreshView();
                elementChanges.addChange(ATTR_ACTIVE_BUTTON, (Object)this.activeButton);
            }
        }
        return elementChanges;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ATTR_ON_BUTTON_CHANGE.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onButtonChange);
        }
        return super.getEventHandler(eventData);
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleButton(this.getSubcomponents().size() + 1));
    }

    public void onDesignerBeforeAdding(IGroupingComponent<?> parent, SpacerService spacerService) {
        this.addSubcomponent((Component)this.createExampleButton(1));
        this.addSubcomponent((Component)this.createExampleButton(2));
    }

    public void setOnButtonChange(ActionBinding onButtonChange) {
        this.onButtonChange = onButtonChange;
    }

    public IActionCallbackContext setOnButtonChange(IActionCallback onButtonChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onButtonChange, this::setOnButtonChange);
    }

    private Button createExampleButton(int nameSuffix) {
        Button button = new Button(this.getForm());
        button.setLabelModelBinding((ModelBinding)new StaticBinding((Object)("Button " + nameSuffix)));
        button.setGroupingParentComponent((IGroupingComponent)this);
        button.init();
        return button;
    }

    public int getActiveButton() {
        return this.activeButton;
    }

    public ActionBinding getOnButtonChange() {
        return this.onButtonChange;
    }

    public ModelBinding getActiveButtonBinding() {
        return this.activeButtonBinding;
    }

    @JsonIgnore
    public void setActiveButtonBinding(ModelBinding activeButtonBinding) {
        this.activeButtonBinding = activeButtonBinding;
    }

    public boolean isMargin() {
        return this.margin;
    }

    public void setMargin(boolean margin) {
        this.margin = margin;
    }
}

