/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Optional;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedAttributesHolder;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.attributes.AttributeHolder;
import pl.fhframework.model.forms.attributes.AttributeHolderBuilder;
import pl.fhframework.model.forms.attributes.FloatingGroupStateAttribute;
import pl.fhframework.model.forms.attributes.FloatingOnlyAttribute;
import pl.fhframework.model.forms.model.FloatingPinMode;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="PanelGroup component responsible for the grouping of sub-elements and can be pinned out from document.", icon="fa fa-object-group")
public class FloatingGroup
extends PanelGroup {
    public static final String ON_PIN_ATTR = "onTogglePin";
    public static final String ON_TOGGLE_FULL_SCREEN_ATTR = "onToggleFullScreen";
    @XMLProperty
    @DocumentedComponentAttribute(value="Floating group offset from top of the screen (floating state only). Negative value would be substracted from the height of the screen.")
    private String top;
    @XMLProperty
    @DocumentedComponentAttribute(value="Floating group offset from left side of the screen (floating state only). Negative value would be substracted from the width of the screen.")
    private String left;
    @XMLProperty
    @DocumentedComponentAttribute(value="Floating group height (floating state only). Negative value would be substracted from the height of the screen. Defaults to height attribute value.")
    private String floatingHeight;
    @XMLProperty
    @DocumentedComponentAttribute(value="Floating group width (floating state only). Negative value would be substracted from the width of the screen. Defaults to width attribute value.")
    private String floatingWidth;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="Name of action which will be invoked after pinning/unpinning")
    private ActionBinding onTogglePin;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty
    @DocumentedComponentAttribute(value="Name of action which will be invoked after toggling full screen")
    private ActionBinding onToggleFullScreen;
    @JsonUnwrapped
    @DocumentedAttributesHolder(attributeClasses={FloatingOnlyAttribute.class, FloatingGroupStateAttribute.class})
    private AttributeHolder attributeHolder;
    @JsonIgnore
    @XMLProperty(value="floatingOnly")
    private ModelBinding<Boolean> floatingOnlyBinding;
    @JsonIgnore
    @XMLProperty(value="floatingState", defaultValue="PINNED_MINIMIZED")
    @DesignerXMLProperty(allowedTypes={FloatingGroupStateAttribute.FloatingState.class})
    private ModelBinding<FloatingGroupStateAttribute.FloatingState> floatingGroupStateBinding;
    @XMLProperty
    @DocumentedComponentAttribute(value="Determines if pinning/fullscreen buttons are hidden.")
    private boolean hideButtons;
    @XMLProperty
    @DocumentedComponentAttribute(value="Determines if header with label and buttons is hidden.")
    private boolean hideHeader;
    @XMLProperty(defaultValue="normal")
    @DocumentedComponentAttribute(defaultValue="normal", value="Pinning mode of the floating group. Valid values are: normal, button, invisible")
    private FloatingPinMode pinningMode = FloatingPinMode.normal;
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(defaultValue="true", value="Determine if user can change position of an element by dragging it.")
    private Boolean isDraggable = true;

    public FloatingGroup(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        FloatingOnlyAttribute floatingOnlyAttribute = new FloatingOnlyAttribute(this.getForm(), (Component)this, this.floatingOnlyBinding);
        this.attributeHolder = new AttributeHolderBuilder().attribute(floatingOnlyAttribute).attribute(new FloatingGroupStateAttribute(this.getForm(), (Component)this, this.floatingGroupStateBinding, floatingOnlyAttribute)).build();
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.attributeHolder.updateView((Component)this, elementChanges);
        return elementChanges;
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        super.updateModel(valueChange);
        this.attributeHolder.updateModel((Component)this.getForm(), valueChange);
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_PIN_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onTogglePin);
        }
        if (ON_TOGGLE_FULL_SCREEN_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onToggleFullScreen);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnTogglePin(ActionBinding onTogglePin) {
        this.onTogglePin = onTogglePin;
    }

    public IActionCallbackContext setOnTogglePin(IActionCallback onTogglePin) {
        return CallbackActionBinding.createAndSet((IActionCallback)onTogglePin, this::setOnTogglePin);
    }

    public void setOnToggleFullScreen(ActionBinding onToggleFullScreen) {
        this.onToggleFullScreen = onToggleFullScreen;
    }

    public IActionCallbackContext setOnToggleFullScreen(IActionCallback onToggleFullScreen) {
        return CallbackActionBinding.createAndSet((IActionCallback)onToggleFullScreen, this::setOnToggleFullScreen);
    }

    public String getTop() {
        return this.top;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getFloatingHeight() {
        return this.floatingHeight;
    }

    public void setFloatingHeight(String floatingHeight) {
        this.floatingHeight = floatingHeight;
    }

    public String getFloatingWidth() {
        return this.floatingWidth;
    }

    public void setFloatingWidth(String floatingWidth) {
        this.floatingWidth = floatingWidth;
    }

    public ActionBinding getOnTogglePin() {
        return this.onTogglePin;
    }

    public ActionBinding getOnToggleFullScreen() {
        return this.onToggleFullScreen;
    }

    public AttributeHolder getAttributeHolder() {
        return this.attributeHolder;
    }

    public ModelBinding<Boolean> getFloatingOnlyBinding() {
        return this.floatingOnlyBinding;
    }

    @JsonIgnore
    public void setFloatingOnlyBinding(ModelBinding<Boolean> floatingOnlyBinding) {
        this.floatingOnlyBinding = floatingOnlyBinding;
    }

    public ModelBinding<FloatingGroupStateAttribute.FloatingState> getFloatingGroupStateBinding() {
        return this.floatingGroupStateBinding;
    }

    @JsonIgnore
    public void setFloatingGroupStateBinding(ModelBinding<FloatingGroupStateAttribute.FloatingState> floatingGroupStateBinding) {
        this.floatingGroupStateBinding = floatingGroupStateBinding;
    }

    public boolean isHideButtons() {
        return this.hideButtons;
    }

    public void setHideButtons(boolean hideButtons) {
        this.hideButtons = hideButtons;
    }

    public boolean isHideHeader() {
        return this.hideHeader;
    }

    public void setHideHeader(boolean hideHeader) {
        this.hideHeader = hideHeader;
    }

    public FloatingPinMode getPinningMode() {
        return this.pinningMode;
    }

    public void setPinningMode(FloatingPinMode pinningMode) {
        this.pinningMode = pinningMode;
    }

    public Boolean getIsDraggable() {
        return this.isDraggable;
    }

    public void setIsDraggable(Boolean isDraggable) {
        this.isDraggable = isDraggable;
    }
}

