/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.springframework.expression.Expression;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.XMLMetadataSubelementParent;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.util.SpelUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Tree;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;

@Control(parents={Tree.class}, canBeDesigned=true)
public class TreeElement
extends GroupingComponent<TreeElement>
implements IHasBoundableLabel,
IChangeableByClient {
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_URL = "url";
    private static final String ATTR_ON_LABEL_CLICK = "onLabelClick";
    private static final String ATTR_ON_ICON_CLICK = "onIconClick";
    private static final String ON_LAZY_LOAD = "onLazyLoad";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_SELECTED = "selected";
    private static final String ATTR_COLLAPSED = "collapsed";
    private static final String ATTR_NEXT_LEVEL_EXPANDABLE = "nextLevelExpandable";
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    private ModelBinding labelModelBinding;
    private String label;
    @JsonIgnore
    @XMLProperty(value="icon")
    private ModelBinding iconBinding;
    private String icon;
    @JsonIgnore
    @XMLProperty(value="url")
    private ModelBinding urlBinding;
    private String url;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(value="onLabelClick")
    private ActionBinding onLabelClick;
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @XMLProperty(value="onIconClick")
    private ActionBinding onIconClick;
    private boolean collapsed = true;
    private boolean wasSelected = false;
    private boolean wasCollapsed = true;
    @JsonIgnore
    private int level;
    @JsonIgnore
    private int[] indices;
    @JsonIgnore
    private String collectionBinding;
    @JsonIgnore
    private String elementBinding;
    @JsonIgnore
    @XMLMetadataSubelementParent
    private Tree tree;
    @JsonIgnore
    private boolean childrenLoaded;
    @JsonIgnore
    private boolean shouldIgnoreLazy = false;
    private boolean nextLevelExpandable;
    private boolean selected;
    @JsonIgnore
    private Expression nextLevelLazyExpandableExpression;

    public TreeElement(Form form) {
        super(form);
    }

    public void init() {
        super.init();
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ATTR_ON_LABEL_CLICK.equals(eventData.getEventType())) {
            if (this.selected) {
                this.tree.onSelectionClick(this.getBoundObject());
            }
            return Optional.ofNullable(this.onLabelClick);
        }
        if (ATTR_ON_ICON_CLICK.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onIconClick);
        }
        if (ON_LAZY_LOAD.equals(eventData.getEventType())) {
            this.shouldIgnoreLazy = true;
            return Optional.empty();
        }
        return super.getEventHandler(eventData);
    }

    public void processComponents() {
        if (this.childrenLoaded && !this.tree.isDynamic()) {
            return;
        }
        if (!this.childrenLoaded && this.tree.isLazy() && !this.shouldIgnoreLazy) {
            return;
        }
        this.tree.processComponentsForLevel(this.indices, this.level + 1, (IGroupingComponent<TreeElement>)this);
        this.childrenLoaded = true;
    }

    public void updateModel(ValueChange valueChange) {
        if (valueChange.hasAttributeChanged(ATTR_SELECTED)) {
            this.wasSelected = this.selected;
            boolean newSelected = valueChange.getBooleanAttribute(ATTR_SELECTED);
            if (newSelected) {
                this.tree.deselectAll();
            }
            this.selected = newSelected;
        }
        if (valueChange.hasAttributeChanged(ATTR_COLLAPSED)) {
            this.wasCollapsed = this.collapsed;
            this.collapsed = valueChange.getBooleanAttribute(ATTR_COLLAPSED);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ElementChanges updateView() {
        elementChanges = super.updateView();
        if (this.iconBinding != null && (bindingResult = this.iconBinding.getBindingResult()) != null && !this.areValuesTheSame(newLabelValue = (String)bindingResult.getValue(), this.icon)) {
            this.icon = newLabelValue;
            elementChanges.addChange("icon", (Object)this.icon);
        }
        if (this.urlBinding != null && (bindingResult = this.urlBinding.getBindingResult()) != null && !this.areValuesTheSame(newLabelValue = (String)bindingResult.getValue(), this.url)) {
            this.url = newLabelValue;
            elementChanges.addChange("url", (Object)this.url);
        }
        if (this.labelModelBinding != null && (bindingResult = this.labelModelBinding.getBindingResult()) != null && !this.areValuesTheSame(newLabelValue = (String)bindingResult.getValue(), this.label)) {
            this.label = newLabelValue;
            elementChanges.addChange("label", (Object)this.label);
        }
        if (this.wasSelected != (isSelected = this.tree.isSelected(this.getBoundObject()))) {
            this.selected = isSelected;
            this.wasSelected = isSelected;
            elementChanges.addChange("selected", (Object)this.selected);
        }
        if (this.wasCollapsed != this.collapsed) {
            this.wasCollapsed = this.collapsed;
            elementChanges.addChange("collapsed", (Object)this.collapsed);
        }
        if (this.tree.isLazy() && !this.childrenLoaded) {
            if (this.nextLevelLazyExpandableExpression == null) {
                this.nextLevelLazyExpandableExpression = SpelUtils.parseExpression((String)StringUtils.removeSurroundingBraces((String)this.tree.getNextLevelExpandableExpression()));
            }
            try {
                newNextLevelExpandable = (Boolean)SpelUtils.evaluateExpression((Expression)this.nextLevelLazyExpandableExpression, (Object)this.getBoundObject());
                if (newNextLevelExpandable != null) ** GOTO lbl29
                newNextLevelExpandable = false;
            }
            catch (ClassCastException e) {
                throw new FhBindingException(this.tree.getNextLevelExpandableExpression() + " is not a boolean expression");
            }
        } else {
            newNextLevelExpandable = this.getSubcomponents().isEmpty() == false;
        }
lbl29:
        // 3 sources

        if (this.nextLevelExpandable != newNextLevelExpandable) {
            this.nextLevelExpandable = newNextLevelExpandable;
            elementChanges.addChange("nextLevelExpandable", (Object)this.nextLevelExpandable);
        }
        return elementChanges;
    }

    private Object getBoundObject() {
        BindingResult bindingResult;
        if (this.collectionBinding != null && (bindingResult = this.getForm().getBindingResult(this.elementBinding, (Component)this)) != null) {
            return bindingResult.getValue();
        }
        return null;
    }

    public void setOnLabelClick(ActionBinding onLabelClick) {
        this.onLabelClick = onLabelClick;
    }

    public IActionCallbackContext setOnLabelClick(IActionCallback onLabelClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onLabelClick, this::setOnLabelClick);
    }

    public void setOnIconClick(ActionBinding onIconClick) {
        this.onIconClick = onIconClick;
    }

    public IActionCallbackContext setOnIconClick(IActionCallback onIconClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onIconClick, this::setOnIconClick);
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getIconBinding() {
        return this.iconBinding;
    }

    @JsonIgnore
    public void setIconBinding(ModelBinding iconBinding) {
        this.iconBinding = iconBinding;
    }

    public String getIcon() {
        return this.icon;
    }

    public ModelBinding getUrlBinding() {
        return this.urlBinding;
    }

    @JsonIgnore
    public void setUrlBinding(ModelBinding urlBinding) {
        this.urlBinding = urlBinding;
    }

    public String getUrl() {
        return this.url;
    }

    public ActionBinding getOnLabelClick() {
        return this.onLabelClick;
    }

    public ActionBinding getOnIconClick() {
        return this.onIconClick;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public int getLevel() {
        return this.level;
    }

    @JsonIgnore
    public void setLevel(int level) {
        this.level = level;
    }

    public int[] getIndices() {
        return this.indices;
    }

    @JsonIgnore
    public void setIndices(int[] indices) {
        this.indices = indices;
    }

    @JsonIgnore
    public void setCollectionBinding(String collectionBinding) {
        this.collectionBinding = collectionBinding;
    }

    public String getCollectionBinding() {
        return this.collectionBinding;
    }

    @JsonIgnore
    public void setElementBinding(String elementBinding) {
        this.elementBinding = elementBinding;
    }

    public String getElementBinding() {
        return this.elementBinding;
    }

    @JsonIgnore
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public Tree getTree() {
        return this.tree;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public boolean isNextLevelExpandable() {
        return this.nextLevelExpandable;
    }

    public void setNextLevelExpandable(boolean nextLevelExpandable) {
        this.nextLevelExpandable = nextLevelExpandable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

